% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode.R
\name{recode}
\alias{recode}
\title{Recode a Variable (\code{car} version)}
\usage{
recode(var, recodes, as.factor, as.numeric = TRUE, levels)
}
\arguments{
\item{var}{numeric vector, character vector, or factor.}

\item{recodes}{character string of recode specifications: see below.}

\item{as.factor}{return a factor; default is \code{TRUE} if var is a
factor, \code{FALSE} otherwise.}

\item{as.numeric}{if \code{TRUE} (the default), and \code{as.factor} is \code{FALSE},
then the result will be coerced to numeric if all values in the result
are numerals—i.e., represent numbers.}

\item{levels}{an optional argument specifying the order of the levels
in the returned factor; the default is to use the sort order of the
level names.}
}
\description{
This function is from the \pkg{car} package. Please see that
help page for details: \code{\link[car:recode]{car::recode()}}.
}
\examples{
x<-rep(1:3,3)
x
rosetta::recode(
  x,
  "c(1,2)='A'; else='B'"
);
rosetta::recode(
  x,
  "1:2='A'; 3='B'"
);
}
\references{
Fox, J. and Weisberg, S. (2019) \emph{An R Companion to
Applied Regression}, Third Edition, Sage.
}
\author{
John Fox \email{jfox@mcmaster.ca}
}
