% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.orcid.R
\name{as.orcid}
\alias{as.orcid}
\title{Convert an ORCID or something like an ORCID object}
\usage{
as.orcid(x, ...)
}
\arguments{
\item{x}{An ORCID id, passed to \code{print}}

\item{...}{Further args passed on to \code{\link[=orcid_id]{orcid_id()}}}
}
\value{
an S3 object of class \code{or_cid}, which pretty prints
for brevity
}
\description{
Convert an ORCID or something like an ORCID object
}
\examples{
\dontrun{
as.orcid(x="0000-0002-1642-628X")
out <- orcid("text:English", rows = 20)
as.orcid(out$`orcid-identifier.path`[1])

# Passon further args to orcid_id()
as.orcid("0000-0002-1642-628X", verbose = TRUE)

# Browse to a profile
# browse(as.orcid("0000-0002-1642-628X"))

# many ORCIDs as a character vector
ids <- c("0000-0002-1642-628X", "0000-0002-9341-7985")
as.orcid(ids)

# many in a list via orcid_id()
(x <- lapply(ids, orcid_id))
as.orcid(x)
}
}
