/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.libror;

public class PartialValueFunction {
    private double[] vals;
    private double[] evals;

    public PartialValueFunction(double[] vals, double[] evals) {
        assert (evals.length == vals.length);
        assert (evals.length >= 2);
        assert (evals[0] == 0.0);
        this.evals = evals;
        this.vals = vals;
    }

    public double evaluate(double point) {
        assert (point >= this.vals[0]);
        assert (point <= this.vals[this.vals.length - 1]);
        int geqIndex = 0;
        while (point > this.vals[geqIndex]) {
            ++geqIndex;
        }
        if (geqIndex == 0) {
            return this.evals[0];
        }
        double prevVal = this.evals[geqIndex - 1];
        double diff = this.evals[geqIndex] - prevVal;
        double prevPoint = this.vals[geqIndex - 1];
        double nextPoint = this.vals[geqIndex];
        return prevVal + diff * ((point - prevPoint) / (nextPoint - prevPoint));
    }

    public String toString() {
        String retStr = "";
        int i = 0;
        while (i < this.vals.length) {
            retStr = String.valueOf(retStr) + "(" + this.vals[i] + ": " + this.evals[i] + ")";
            if (i != this.vals.length - 1) {
                retStr = String.valueOf(retStr) + " ";
            }
            ++i;
        }
        return retStr;
    }

    public double[] getEvals() {
        return this.evals;
    }

    public double[] getVals() {
        return this.vals;
    }
}

