/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.libror;

import java.util.Arrays;
import org.apache.commons.math.random.MersenneTwister;

public class RandomUtil {
    private static MersenneTwister random = new MersenneTwister(1639);

    public static double createUnif01() {
        return random.nextDouble();
    }

    public static void createSumToRand(double[] dest, double sumTo) throws NullPointerException {
        assert (sumTo >= 0.0);
        if (dest == null) {
            throw new NullPointerException("destination array null");
        }
        int len = dest.length;
        for (int i = 0; i < len - 1; ++i) {
            dest[i] = RandomUtil.createUnif01() * sumTo;
        }
        dest[len - 1] = sumTo;
        Arrays.sort(dest);
        double last = 0.0;
        for (int i = 0; i < len; ++i) {
            double t = dest[i];
            dest[i] = t - last;
            last = t;
        }
    }

    public static void createSumToOneRand(double[] dest) throws NullPointerException {
        RandomUtil.createSumToRand(dest, 1.0);
    }

    public static void createSumToOneSorted(double[] dest) throws NullPointerException {
        RandomUtil.createSumToOneRand(dest);
        Arrays.sort(dest);
    }
}

