% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prov.R
\docType{methods}
\name{rbind}
\alias{rbind}
\alias{rbind,ProvStoreDF-method}
\title{rbind method}
\usage{
rbind(..., deparse.level = 1)

\S4method{rbind}{ProvStoreDF}(..., deparse.level = 1)
}
\arguments{
\item{\dots}{Two or more ProvStoreDF objects. Must all have
identical hashprefix values}

\item{deparse.level}{ignored.}
}
\value{
A ProvStoreDF object.
}
\description{
an rbind method for ProvStoreDF objects
}
\examples{
library(fastdigest)
library(roprov)
code = c("x = 5", "y = x + 1")
outvars = c("x", "y")
outvarhashes = c(fastdigest(5), fastdigest(6))
outvarclasses = rep("numeric", 2)
invars = c("", "x")
invarhashes = c("", fastdigest(5))
invarclasses = c("", "numeric")
 df = data.frame(outputvar = outvars,
                 outputvarhash = outvarhashes,
                 outputvarclass = outvarclasses,
                 inputvar= invars,
                 inputvarhash = invarhashes,
                 inputvarclass = invarclasses,
                 agent = "coolgirloruy",
                 code = code,
                 codehash = sapply(code, fastdigest),
                 stringsAsFactors = FALSE)

ps2 = ProvStoreDF(df = df)
rbind(ps2, ps2)
}
