% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prov.R
\docType{class}
\name{ProvStoreDF-class}
\alias{ProvStoreDF-class}
\alias{makeProvStore}
\alias{ProvStoreDF}
\title{ProvStoreDF constructors and class}
\usage{
makeProvStore(invarhashes = NULL, outvarhashes = NULL, code = NULL,
  codehash = fastdigest(code), invars = names(invarhashes),
  outvars = names(outvarhashes), invarclasses = character(),
  outvarclasses = character(), agent = getUser(), hashprefix = "SpookyV2")

ProvStoreDF(outvars = character(), outvarhashes = character(),
  outvarclasses = character(), invars = character(),
  invarhashes = character(), invarclasses = character(),
  agent = character(), code = character(), codehash = vapply(code,
  fastdigest, character(1)), hashprefix = "SpookyV2", df = NULL)
}
\arguments{
\item{invarhashes}{character. Hashes of values for input variables
(or NULL).}

\item{outvarhashes}{character. Hashes of values for output
variables (or NULL).}

\item{code}{character. The code associated with the input and
output variables in question.}

\item{codehash}{character. The hash of the (parsed and deparsed)
code.}

\item{invars}{character. The set of input variables (symbols) to
\code{code}}

\item{outvars}{character. The output variable(s) (symbols) to
\code{code}.}

\item{invarclasses}{character. The (top level) classes of the
input variable values.}

\item{outvarclasses}{character. The (top level) classes of the
output variable values.}

\item{agent}{character. a string identifying the user. Defaults to
the output of a \code{whoami} system call.}

\item{hashprefix}{character. A prefix to append to the hashes if
not present already to make them more self-describing.}

\item{df}{data.frame. Optional. An already constructed data.frame
do use as the provdata of the constructed \code{ProvStoreDF}
object.}
}
\description{
Functions to create a valid ProvStore object from raw data
about evaluation history (including hashes of input and output variable
values).
}
\details{
makeProvStore expects information about a single code unit. i.e.,
all input values will be counted as inputs for all outputs. For
makeProvStore the number of inputs and outputs need not match, and the
appropriate replication on inputs will happen automatically.

ProvStoreDF is a direct constructor and thus expects the replciation of
inputs for multiple outputs to have already occurred.
}
\examples{
## spoof the information needed to create a provstore
library(fastdigest)
code = c("x = 5", "y = x + 1")
outvars = c("x", "y")
outvarhashes = c(fastdigest(5), fastdigest(6))
outvarclasses = rep("numeric", 2)
invars = c("", "x")
invarhashes = c("", fastdigest(5))
invarclasses = c("", "numeric")

ps = ProvStoreDF(outvars = outvars,
                 outvarhashes = outvarhashes,
                 outvarclasses = outvarclasses,
                 invars = invars,
                 invarhashes = invarhashes,
                 invarclasses = invarclasses,
                 code = code,
                 agent = "coolguyorgirl")

 df = data.frame(outputvar = outvars,
                 outputvarhash = outvarhashes,
                 outputvarclass = outvarclasses,
                 inputvar= invars,
                 inputvarhash = invarhashes,
                 inputvarclass = invarclasses,
                 agent = "coolgirloruy",
                 code = code,
                 codehash = sapply(code, fastdigest),
                 stringsAsFactors = FALSE)

ps2 = ProvStoreDF(df = df)
}
