% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table_transform.R
\name{select_attributes}
\alias{select_attributes}
\alias{select_attributes.flat_table}
\title{Select attributes of a flat table}
\usage{
select_attributes(ft, attributes)

\method{select_attributes}{flat_table}(ft, attributes)
}
\arguments{
\item{ft}{A \code{flat_table} object.}

\item{attributes}{A vector of names.}
}
\value{
A \code{flat_table} object.
}
\description{
Select only the indicated attributes from the flat table.
}
\examples{

ft <- flat_table('iris', iris) |>
  select_attributes(attributes = c('Species'))

ft <- flat_table('ft_num', ft_num) |>
  select_attributes(attributes = c('Year', 'WEEK', 'Week Ending Date'))

}
\seealso{
\code{\link{flat_table}}

Other flat table transformation functions: 
\code{\link{add_custom_column}()},
\code{\link{remove_instances_without_measures}()},
\code{\link{replace_empty_values}()},
\code{\link{replace_string}()},
\code{\link{replace_unknown_values}()},
\code{\link{select_instances_by_comparison}()},
\code{\link{select_instances}()},
\code{\link{select_measures}()},
\code{\link{separate_measures}()},
\code{\link{transform_attribute_format}()},
\code{\link{transform_from_values}()},
\code{\link{transform_to_attribute}()},
\code{\link{transform_to_measure}()},
\code{\link{transform_to_values}()}
}
\concept{flat table transformation functions}
