% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plainMethod_buildFromWorkbook.r
\name{buildFromWorkbook}
\alias{buildFromWorkbook}
\title{Build a model from the contents of a workbook}
\usage{
buildFromWorkbook(workbook, dim = 1, fortran = FALSE, sources = NULL, ...)
}
\arguments{
\item{workbook}{File path of the workbook. The file type is guessed from
the extension which must be '.xlsx' or '.ods'. See below for the mandatory
worksheets that must be present in the workbook.}

\item{dim}{The number of spatial compartments, possibly in multiple
dimensions. For single-box models without spatial resolution, use
\code{dim=1} (default). For a one-dimensional model with 10 compartments
use, e.g., \code{dim=10}. See the \code{dim} argument of the method
\code{\link[rodeo]{initialize}} for further details.}

\item{fortran}{Controls the language of code generation. The default
(\code{FALSE}) produces R code. Use \code{TRUE} if you want to use
compiled Fortran code for better performance. In the latter case, you will
need a Fortran compiler which is accessible by R.}

\item{sources}{Only relevant if \code{fortran=TRUE}. The argument
allows the name(s) of additional source file(s) to be provided
for processing by the Fortran compiler. In any case, the Fortran code
in \code{sources} must implement a module with the fixed name 'functions'.
This module must contain all user-defined functions referenced in any
process rate expressions or any cell of the stoichiometry matrix.}

\item{...}{Optional arguments passed to \code{\link[readxl]{read_excel}}
or \code{\link[readODS]{read_ods}}, respectively.}
}
\value{
An object of class \code{\link[rodeo]{rodeo}}.
}
\description{
The function builds a \code{\link[rodeo]{rodeo}}-based model by importing
all declarations and equations from a workbook established with common
spreadsheet software.
}
\note{
The file provided as \code{workbook} must contain at least the four
  mandatory sheets:
\itemize{
  \item{'vars'} Declares the state variables of the model. Mandatory columns
     are 'name', 'unit', 'description'.
  \item{'pars'} Declares the parameters of the model. Mandatory columns
     are the same as for sheet 'vars'.
  \item{'funs'} Declares user-defined functions appearing in any equations of
     the model. Mandatory columns are the same as for sheet 'vars'. If
     source code is generated for R (\code{fortran=FALSE}), the declared
     functions must be accessible in the environment where the model is
     run. If \code{fortran=TRUE}, the functions must be implemented in the
     file(s) listed in \code{sources} to be included in compilation.
  \item{'eqns'} Specifies the model equations. Mandatory columns
     are 'name', 'unit', 'description', 'expression' plus one column for
     every state variable of the model. The 'expression' columns holds the
     process rate expressions and columns named after state variables
     contain the corresponding stoichiometric factors.
}
The best way to understand the contents of a suitable workbook is to study
the examples in the folder 'models' shipped with the package. Type
\code{system.file("models", package="rodeo")} at the R prompt to see
where this folder is installed on your system.
}
\examples{

# Build a SEIR type epidemic model
m <- buildFromWorkbook(
  system.file("models/SEIR.xlsx", package="rodeo")
)
m$setPars(setNames(m$getParsTable()$default,
  m$getParsTable()$name))
m$setVars(setNames(m$getVarsTable()$default,
  m$getVarsTable()$name))
x <- m$dynamics(times=0:30, fortran=FALSE)
print(head(x))
}
\author{
David Kneis \email{david.kneis@tu-dresden.de}
}
