% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heading.R
\name{heading}
\alias{heading}
\title{Print a heading}
\usage{
heading(
  ...,
  headingLevel = rock::opts$get("defaultHeadingLevel"),
  output = "markdown",
  cat = TRUE
)
}
\arguments{
\item{...}{The heading text: pasted together with no separator.}

\item{headingLevel}{The level of the heading; the default can be set
with e.g. \code{rock::opts$set(defaultHeadingLevel=1)}.}

\item{output}{Whether to output to HTML ("\code{html}") or markdown (anything
else).}

\item{cat}{Whether to cat (print) the heading or just invisibly return it.}
}
\value{
The heading, invisibly.
}
\description{
This is just a convenience function to print a markdown or HTML heading at
a given 'depth'.
}
\examples{
heading("Hello ", "World", headingLevel=5);
### This produces: "\\n\\n##### Hello World\\n\\n"
}
