
<!-- README.md is generated from README.Rmd. Please edit that file -->

<!-- badges: start -->

[![Pipeline
status](https://gitlab.com/r-packages/rock/badges/master/pipeline.svg)](https://gitlab.com/r-packages/rock/commits/master)
[![Coverage
status](https://codecov.io/gl/r-packages/rock/branch/master/graph/badge.svg)](https://codecov.io/gl/r-packages/rock?branch=master)
[![Version on
CRAN](https://www.r-pkg.org/badges/version/rock?color=brightgreen)](https://cran.r-project.org/package=rock)
[![Version on
CRAN](https://cranlogs.r-pkg.org/badges/last-month/rock?color=brightgreen)](https://cran.r-project.org/package=rock)
[![Version on
CRAN](https://cranlogs.r-pkg.org/badges/grand-total/rock?color=brightgreen)](https://cran.r-project.org/package=rock)
<!-- [![Dependency status](https://tinyverse.netlify.com/badge/rock)](https://CRAN.R-project.org/package=rock) -->
<!-- badges: end -->

# <img src='img/hex-logo.png' align="right" height="200" /> rock 📦

## Reproducible Open Coding Kit

The pkgdown website for this project is located at
<https://r-packages.gitlab.io/rock>.

<!--------------------------------------------->

<!-- Start of a custom bit for every package -->

<!--------------------------------------------->

The Reproducible Open Coding Kit (ROCK, and this package, `rock`) was
developed to facilitate reproducible and open coding, specifically
geared towards qualitative research methods. Although it is a
general-purpose toolkit, three specific applications have been
implemented, specifically an interface to the `rENA` package that
implements Epistemic Network Analysis (ENA), means to process notes from
Cognitive Interviews (CIs), and means to work with a decentralized
construct taxonomy (DCT).

See the [introductory
vignette](https://r-packages.gitlab.io/rock/articles/introduction_to_rock.html)
for an introduction.

There is a FLOSS interface for the ROCK, iROCK, available at
<https://r-packages.gitlab.io/rock/iROCK/>

<!--------------------------------------------->

<!--  End of a custom bit for every package  -->

<!--------------------------------------------->

## Installation

You can install the released version of `rock` from
[CRAN](https://CRAN.R-project.org) with:

``` r
install.packages('rock');
```

You can install the development version of `rock` from
[GitLab](https://about.gitlab.com/) with:

``` r
remotes::install_gitlab('r-packages/rock');
```

(assuming you have `remotes` installed; otherwise, install that first
using the `install.packages` function)

<!--------------------------------------------->

<!-- Start of a custom bit for every package -->

<!--------------------------------------------->

<!-- ## References -->

<!-- van Woerkum, C. and Aarts, N. (2012), ‘Accountability: New challenges, new forms’, *Journal of Organizational Transformation & Social Change*, 9, pp. 271–283, \doi{10.1386/jots.9.3.271_1}. -->

<!--------------------------------------------->

<!--  End of a custom bit for every package  -->

<!--------------------------------------------->
