% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{fit_pred_fold}
\alias{fit_pred_fold}
\title{Cross validation on fold i}
\usage{
fit_pred_fold(i, x, y, folds, fit_method, family, non_pen_vars = NULL, ...)
}
\arguments{
\item{i}{target partition}

\item{x}{matrix of predictors}

\item{y}{vector of responses}

\item{folds}{defines how data is seperated into folds for cross validation}

\item{fit_method}{model being used to fit the data}

\item{family}{family used to fit the data}

\item{non_pen_vars}{index of variables that will not be penalized if glmnet is used}

\item{...}{additional commmands to glm or cv.glmnet}
}
\value{
returns predictions for partition i
}
\description{
Cross validation on fold i
}
\examples{
folds_10 <- randomly_assign(100,10)
x <- matrix(rnorm(800),ncol=8)
y <- runif(100) < exp(1 + x[,1] + x[,5])/(1+exp(1 + x[,1] + x[,5]))
fold_1_results <- fit_pred_fold(1,x,y,folds_10,"glm","binomial")
fold_2_results <- fit_pred_fold(2,x,y,folds_10,"glm","binomial") 
}
\author{
Ben Sherwood <ben.sherwood@ku.edu>
}

