\name{p.rocc}
\Rdversion{1.2}
\alias{p.rocc}
\title{
Making predictions using the ROC based classifier
}
\description{
Class predictions of new samples using a ROC based classifier obtained by tr.rocc()
}
\usage{
p.rocc(trocc, newsample)
}
\arguments{
  \item{trocc}{a ROC based classifier (containing the classifier specifications). This object is generated in training data using tr.rocc()
}
  \item{newsample}{a matrix containing the new samples, with genes as rows and samples as columns. rownames(g) and colnames (g) must be specified.
    All features of the classifier (trocc$genes) have to be present in the rownames of the matrix.
}
}
\details{
The classifier specifications of the trocc object from classifier training are used to classify new samples.
The metagene value of the new sample is calculated using the information from trocc$positiv and trocc$negativ.
If the metagene value is higher than the threshold value (obtained from trocc$cutoffvalue) the new sample is predicted to be of class 1, else to be of class 0.
}
\value{
a named factor vector with levels 0 and 1 containing the predictions.
}
\references{
Lauss M, Frigyesi A, Ryden T, Hoglund M. Robust assignment of cancer subtypes from expression data using a uni-variate gene expression average as classifier. BMC Cancer 2010 (in print)
}
\author{
Martin Lauss
}
\note{
p.rocc() requires a trocc object generated by the tr.rocc() function
}
\seealso{
tr.rocc, o.rocc
}
\examples{
#### tr.rocc

### Random Dataset and phenotype
set.seed(100)
## Dataset should be a matrix
g <- matrix(rnorm(1000*25),ncol=25)
rownames(g) <- paste("Gene",1:1000,sep="_")
colnames(g) <- paste("Sample",1:25,sep="_")
## Phenotype should be a factor with levels 0 and 1: 
out <- as.factor(sample(c(0:1),size=25,replace=TRUE))

predictor <- tr.rocc (g,out,xgenes=50)

## find classifier specification:
predictor$positiv
predictor$negativ
predictor$cutoffvalue




#### p.rocc

### just an example: classification of the training samples
p.rocc(trocc=predictor,newsample=g)
predictions<-p.rocc(trocc=predictor,newsample=g)
table(predictions,out)
## all correctly classified because newsample is the training set
## (try UNSEEN validation data instead)



}
\keyword{classif}

