% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot-methods}
\alias{plot-methods}
\alias{autoplot.fit_mediation}
\alias{autoplot.test_mediation}
\alias{plot.fit_mediation}
\alias{plot.test_mediation}
\title{Plot (robust) mediation analysis results}
\usage{
\method{autoplot}{fit_mediation}(object, ...)

\method{autoplot}{test_mediation}(object, which = c("ci", "density",
  "ellipse"), ...)

\method{plot}{fit_mediation}(x, ...)

\method{plot}{test_mediation}(x, which = c("ci", "density", "ellipse"),
  ...)
}
\arguments{
\item{object, x}{an object inheriting from class
\code{"\link{fit_mediation}"} or \code{"\link{test_mediation}"} containing
results from (robust) mediation analysis.}

\item{\dots}{additional arguments to be passed down.}

\item{which}{a character string specifying which plot to produce.
Possible values are \code{"ci"} for a dot plot of selected effects
together with confidence intervals (see \code{\link{ci_plot}()}),
\code{"density"} for a density plot of the indirect effect(s) (see
\code{\link{density_plot}()}), or \code{"ellipse"} for a diagnostic plot
of the data together with a tolerance ellipse (see
\code{\link{ellipse_plot}()}).}
}
\value{
An object of class \code{"\link[ggplot2]{ggplot}"}.
}
\description{
Visualize results from (robust) mediation analysis.
}
\details{
The \code{"\link{fit_mediation}"} method is a wrapper for
\code{\link{ellipse_plot}()}.

The \code{"\link{test_mediation}"} method calls \code{\link{ci_plot}()},
\code{\link{density_plot}()}, or \code{\link{ellipse_plot}()}, depending
on the argument \code{which}.
}
\examples{
data("BSG2014")

# run fast and robust bootstrap test
robust_boot <- test_mediation(BSG2014,
                              x = "ValueDiversity",
                              y = "TeamCommitment",
                              m = "TaskConflict",
                              robust = TRUE)

# create plots for robust bootstrap test
plot(robust_boot, which = "ci")
plot(robust_boot, which = "density")
plot(robust_boot, which = "ellipse")

}
\seealso{
\code{\link{fit_mediation}()}, \code{\link{test_mediation}()}

\code{\link{ci_plot}()}, \code{\link{density_plot}()},
\code{\link{ellipse_plot}()}
}
\author{
Andreas Alfons
}
\keyword{hplot}
