% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pTab.R
\name{pTab}
\alias{pTab}
\title{Propability table}
\usage{
pTab(x, method = "dirichlet", alpha = 1/length(as.numeric(x)))
}
\arguments{
\item{x}{an object of class table}

\item{method}{default is \sQuote{dirichlet}. Other available methods: 
\sQuote{classical} that is function \code{prop.table()} from package base or method \dQuote{half} that add 1/2 to each cell
to avoid zero problems.}

\item{alpha}{constant used for method \sQuote{dirichlet}}
}
\value{
The probablity table
}
\description{
Calculates the propability table using different methods
}
\examples{
data(precipitation) 
pTab(precipitation)
pTab(precipitation, method = "dirichlet")
}
\references{
Juan Jose Egozcuea, Vera Pawlowsky-Glahn, Matthias Templ, Karel Hron (2015)
Independence in Contingency Tables Using Simplicial Geometry. 
\emph{Communications in Statistics - Theory and Methods}, Vol. 44 (18), 3978--3996.
DOI:10.1080/03610926.2013.824980
}
\author{
Matthias Templ
}
