% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterToLineSegments.R
\name{rasterToLineSegments}
\alias{rasterToLineSegments}
\title{Convert raster to lines}
\usage{
rasterToLineSegments(rast, method = "mst")
}
\arguments{
\item{rast}{raster representing lines all values > 0 are assumed to be lines}

\item{method}{method of building lines. See Details}
}
\value{
an sf simple feature collection
}
\description{
Converts rasters that represent lines into an sf object.
}
\details{
For \code{method = "nearest"} raster is first converted to points and then
lines are drawn between the nearest points. If there are two different ways
to connect the points that have the same distance both are kept which can
cause doubled lines. USE WITH CAUTION. \code{method = "mst"} converts the
raster to points, reclassifies the raster so roads are 0 and other cells are
1 and then uses \code{projectRoads} to connect all the points with a minimum
spanning tree. This will always connect all raster cells and is slower but
will not double lines as often. Neither method is likely to work for very
large rasters
}
\examples{
CLUSexample <- prepExData(CLUSexample)
# works well for very simple roads
roadLine1 <- rasterToLineSegments(CLUSexample$roads)

# longer running more realistic examples
\donttest{
demoScen <- prepExData(demoScen)
# mst method works well in this case
roadLine2 <- rasterToLineSegments(demoScen[[1]]$road.rast)

# nearest method has doubled line where the two roads meet
roadLine3 <- rasterToLineSegments(demoScen[[1]]$road.rast, method = "nearest")

# The mst method can also produce odd results in some cases
roadLine4 <- rasterToLineSegments(demoScen[[4]]$road.rast)

}

}
