% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npn_phenophases.R
\name{npn_phenophases_by_species}
\alias{npn_phenophases_by_species}
\title{Get Phenophase for Species}
\usage{
npn_phenophases_by_species(species_ids, date, ...)
}
\arguments{
\item{species_ids}{Integer vector of species IDs for which to get phenophase
information.}

\item{date}{The applicable date for which to retrieve phenophases for the
given species.}

\item{...}{Currently unused.}
}
\value{
A tibble listing phenophases in the NPN database for the specified
species and date.
}
\description{
Retrieves the phenophases applicable to species for a given date. It's
important to specify a date since protocols/phenophases for any given species
can change from year to year.
}
\examples{
\dontrun{
pp <- npn_phenophases_by_species(3, "2018-05-05")
}
}
