% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npn_geoserver.R
\name{npn_get_custom_agdd_raster}
\alias{npn_get_custom_agdd_raster}
\title{Get Custom AGDD Raster Map}
\usage{
npn_get_custom_agdd_raster(
  method,
  climate_data_source,
  temp_unit,
  start_date,
  end_date,
  base_temp,
  upper_threshold = NULL
)
}
\arguments{
\item{method}{Takes "simple" or "double-sine" as input. This is the AGDD calculation method to use for each
data point. Simple refers to simple averaging.}

\item{climate_data_source}{Specified the climate data set to use. Takes either "PRISM" or "NCEP" as input.}

\item{temp_unit}{The unit of temperature to use in the calculation. Takes either "Fahrenheit" or "Celsius" as input.}

\item{start_date}{Date at which to begin the AGDD calculations}

\item{end_date}{Date at which to end the AGDD calculations}

\item{base_temp}{This is the lowest temperature for each day  for it to be considered in the calculation.}

\item{upper_threshold}{This parameter is only applicable for the double-sine method. This sets the highest temperature
to be considered in any given day's AGDD calculation}
}
\description{
This function takes a series of variables used in calculating AGDD and returns
a raster of the continental USA with each pixel representing the calculated AGDD value
based on start and end date.
This function leverages the USA-NPN geo web services
}
