% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buoy.R
\name{buoy}
\alias{buoy}
\alias{buoys}
\alias{buoy_stations}
\title{Get NOAA buoy data from the National Buoy Data Center}
\usage{
buoy(dataset, buoyid, year = NULL, datatype = NULL, ...)

buoys(dataset)

buoy_stations(refresh = FALSE, ...)
}
\arguments{
\item{dataset}{(character) Dataset name to query. See below for Details.
Required}

\item{buoyid}{Buoy ID, can be numeric/integer/character. Required}

\item{year}{(integer) Year of data collection. Optional}

\item{datatype}{(character) Data type, one of 'c', 'cc', 'p', 'o'. Optional}

\item{...}{Curl options passed on to \link[crul:verb-GET]{crul::verb-GET}
Optional. A number of different HTTP requests are made internally, but
we only pass this on to the request to get the netcdf file in the internal
function \code{get_ncdf_file()}}

\item{refresh}{(logical) Whether to use cached data (\code{FALSE}) or get
new data (\code{FALSE}). Default: \code{FALSE}}
}
\value{
If netcdf data has lat/lon variables, then we'll parse into a
tidy data.frame. If not, we'll give back the ncdf4 object for the user
to parse (in which case the data.frame will be empty).
}
\description{
Get NOAA buoy data from the National Buoy Data Center
}
\details{
Functions:
\itemize{
\item buoy_stations - Get buoy stations. A cached version of the dataset
is available in the package. Beware, takes a long time to run if you
do \code{refresh = TRUE}
\item buoys - Get available buoys given a dataset name
\item buoy - Get data given some combination of dataset name, buoy ID,
year, and datatype
}

Options for the dataset parameter. One of:
\itemize{
\item adcp - Acoustic Doppler Current Profiler data
\item adcp2 - MMS Acoustic Doppler Current Profiler data
\item cwind - Continuous Winds data
\item dart - Deep-ocean Assessment and Reporting of Tsunamis data
\item mmbcur - Marsh-McBirney Current Measurements data
\item ocean - Oceanographic data
\item pwind - Peak Winds data
\item stdmet - Standard Meteorological data
\item swden - Spectral Wave Density data with Spectral Wave Direction data
\item wlevel - Water Level data
}
}
\examples{
\dontrun{
if (crul::ok("https://dods.ndbc.noaa.gov/thredds", timeout_ms = 1000)) {

# Get buoy station information
x <- buoy_stations()
# refresh stations as needed, takes a while to run
# you shouldn't need to update very often
# x <- buoy_stations(refresh = TRUE)
if (interactive() && requireNamespace("leaflet")){
library("leaflet")
z <- leaflet(data = na.omit(x))
z <- leaflet::addTiles(z)
leaflet::addCircles(z, ~lon, ~lat, opacity = 0.5)
}

# Get available buoys
buoys(dataset = 'cwind')

# Get data for a buoy
## if no year or datatype specified, we get the first file
buoy(dataset = 'cwind', buoyid = 46085)

# Including specific year
buoy(dataset = 'cwind', buoyid = 41001, year = 1999)

# Including specific year and datatype
buoy(dataset = 'cwind', buoyid = 45005, year = 2008, datatype = "c")
buoy(dataset = 'cwind', buoyid = 41001, year = 1997, datatype = "c")

# Other datasets
buoy(dataset = 'ocean', buoyid = 41029)

# curl debugging
buoy(dataset = 'cwind', buoyid = 46085, verbose = TRUE)

# some buoy ids are character, case doesn't matter, we'll account for it
buoy(dataset = "stdmet", buoyid = "VCAF1")
buoy(dataset = "stdmet", buoyid = "wplf1")
buoy(dataset = "dart", buoyid = "dartu")

}
}
}
\references{
http://www.ndbc.noaa.gov/, http://dods.ndbc.noaa.gov/
}
