% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/erddap_grid.R
\name{erddap_grid}
\alias{erddap_grid}
\title{Get ERDDAP griddap data.}
\usage{
erddap_grid(x, ..., fields = "all", stride = 1, store = disk(),
  callopts = list())
}
\arguments{
\item{x}{Anything coercable to an object of class erddap_info. So the output of a call to
\code{erddap_info}, or a datasetid, which will internally be passed through \code{erddap_info}.}

\item{...}{Dimension arguments.}

\item{fields}{Fields to return, a character vector.}

\item{stride}{(integer) How many values to get. 1 = get every value, 2 = get every other value,
etc. Default: 1 (i.e., get every value)}

\item{store}{One of \code{disk} (default) or \code{memory}. You can pass options to \code{disk}}

\item{callopts}{Pass on curl options to \code{\link[httr]{GET}}}
}
\description{
Get ERDDAP griddap data.
}
\details{
Details:
}
\section{Dimensions and Variables}{

ERDDAP grid dap data has this concept of dimenions vs. variables. So, dimensions are things
like time, latitude, longitude, and altitude. Whereas variables are the measured variables,
e.g., temperature, salinity, and air.

You can't separately adjust values for dimensions for different variables. So, here's how it's
gonna work:

Pass in lower and upper limits you want for each dimension as a vector (e.g., \code{c(1,2)}),
or leave to defaults (i.e., don't pass anything to a dimension). Then pick which variables
you want returned via the \code{fields} parameter. If you don't pass in options to the
\code{fields} parameter, you get all variables back.

To get the dimensions and variables, along with other metadata for a dataset, run
\code{erddap_info}, and each will be shown, with their min and max values, and some
other metadata.
}

\section{Where does the data go?}{

You can choose where data is stored. Be careful though. With griddap data, you can easily get a
single file of hundreds of MB's or GB's in size with a single request. Using \code{disk()}
caches files based on the URL of the request you perform, which is the combination of all
parameters passed in, so if you refine a query by certain fields, etc., you will cach a
different file.  If you choose \code{overwrite=TRUE} within the \code{disk()} function then
you'll force writing a new file to disk. When you use \code{memory()}, no files are cached,
data is stored in R's memory.
}
\examples{
\dontrun{
# single variable dataset
## You can pass in the outpu of a call to erddap_info
(out <- erddap_info('noaa_esrl_027d_0fb5_5d38'))
(res <- erddap_grid(out,
 time = c('2012-01-01','2012-06-12'),
 latitude = c(21, 18),
 longitude = c(-80, -75)
))
## Or, pass in a dataset id
(res <- erddap_grid(x='noaa_esrl_027d_0fb5_5d38',
 time = c('2012-01-01','2012-06-12'),
 latitude = c(21, 18),
 longitude = c(-80, -75)
))

# multi-variable dataset
(out <- erddap_info('noaa_gfdl_5081_7d4a_7570'))
(res <- erddap_grid(out,
 time = c('2005-11-01','2006-01-01'),
 latitude = c(20, 21),
 longitude = c(10, 11)
))
(res <- erddap_grid(out, time = c('2005-11-01','2006-01-01'), latitude = c(20, 21),
   longitude = c(10, 11), fields = 'uo'))
(res <- erddap_grid(out, time = c('2005-11-01','2006-01-01'), latitude = c(20, 21),
   longitude = c(10, 11), fields = 'uo', stride=c(1,2,1,2)))
(res <- erddap_grid(out, time = c('2005-11-01','2006-01-01'), latitude = c(20, 21),
   longitude = c(10, 11), fields = c('uo','so')))
(res <- erddap_grid(out, time = c('2005-09-01','2006-01-01'), latitude = c(20, 21),
   longitude = c(10, 11), fields = 'none'))

# multi-variable dataset
## this one also has a 0-360 longitude system, BLARGH!!!
(out <- erddap_info('noaa_gfdl_3c96_7879_a9d3'))
(res <- erddap_grid(out,
 time = c('2005-11-01','2006-01-01'),
 latitude = c(20, 22),
 longitude = c(-80, -75)
))
(res <- erddap_grid(out,
 time = c('2005-11-01','2006-01-01'),
 latitude = c(20, 22),
 longitude = c(-80, -75),
 depth = c(5, 50)
))

# Write to memory (within R), or to disk
(out <- erddap_info('noaa_pfeg_e9ae_3356_22f8'))
## disk, by default (to prevent bogging down system w/ large datasets)
## you can also pass in path and overwrite options to disk()
(res <- erddap_grid(out,
 time = c('2012-06-01','2012-06-12'),
 latitude = c(20, 21),
 longitude = c(-80, -75),
 store = disk()
))
## the 2nd call is much faster as it's mostly just the time of reading in the table from disk
system.time( erddap_grid(out,
 time = c('2012-06-01','2012-06-12'),
 latitude = c(20, 21),
 longitude = c(-80, -75),
 store = disk()
) )
system.time( erddap_grid(out,
 time = c('2012-06-01','2012-06-12'),
 latitude = c(20, 21),
 longitude = c(-80, -75),
 store = disk()
) )

## memory
(res <- erddap_grid(out,
 time = c('2012-06-01','2012-06-12'),
 latitude = c(20, 21),
 longitude = c(-80, -75),
 store = memory()
))
}
}
\author{
Scott Chamberlain <myrmecocystus@gmail.com>
}
\references{
\url{http://upwell.pfeg.noaa.gov/erddap/index.html}
}
\seealso{
\code{\link{erddap_table}} \code{\link{erddap_clear_cache}}
}

