% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankosucra.plot_function.R
\name{rankosucra_plot}
\alias{rankosucra_plot}
\title{Rankograms and SUCRA curves}
\usage{
rankosucra_plot(full, drug_names)
}
\arguments{
\item{full}{An object of S3 class \code{\link{run_model}}. See 'Value' in
\code{\link{run_model}}.}

\item{drug_names}{A vector of labels with the name of the interventions in
the order they appear in the argument \code{data} of
\code{\link{run_model}}. If \code{drug_names} is not defined,
the order of the interventions as they appear in \code{data} is used,
instead.}
}
\value{
A panel of rankograms with integrated SUCRA curves for each
  intervention in the network (Salanti et al., 2011). The x-axis of each
  panel refers to the ranking, and the y-axis refers to the ranking
  probability expressed in percentage.
}
\description{
Returns a panel of rankograms with integrated SUCRA curves for
  each intervention in the network.
}
\details{
Interventions are sorted in the descending order of their SUCRA
  value. The SUCRA value expressed in percentage appears on the top left
  corner of each panel.

  \code{rankosucra_plot} can be used only for a network of interventions.
  Otherwise, the execution of the function will be stopped and an error
  message will be printed on the R console.
}
\examples{
data("nma.liu2013")

# Read results from 'run_model' (using the default arguments)
res <- readRDS(system.file('extdata/res_liu.rds', package = 'rnmamod'))

# The names of the interventions in the order they appear in the dataset
interv_names <- c("placebo", "pramipexole",
                  "serotonin-norepinephrine reuptake inhibitor",
                  "serotonin reuptake inhibitor",
                  "tricyclic antidepressant", "pergolide")

# Create the integrated rankograms and SUCRA curves
rankosucra_plot(full = res,
                drug_names = interv_names)

}
\references{
Salanti G, Ades AE, Ioannidis JP. Graphical methods and numerical summaries
for presenting results from multiple-treatment meta-analysis: an overview and
tutorial. \emph{J Clin Epidemiol} 2011;\bold{64}(2):163--71.
\doi{10.1016/j.jclinepi.2010.03.016}
}
\seealso{
\code{\link{run_model}}
}
\author{
{Loukia M. Spineli}, {Chrysostomos Kalyvas},
  {Katerina Papadimitropoulou}
}
