% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.diagnostics_function.R
\name{mcmc_diagnostics}
\alias{mcmc_diagnostics}
\title{Markov Chain Monte Carlo diagnostics}
\usage{
mcmc_diagnostics(net, par = NULL)
}
\arguments{
\item{net}{An object of S3 class \code{\link{run_model}},
\code{\link{run_series_meta}}, \code{\link{run_nodesplit}},
\code{\link{run_ume}}, \code{\link{run_sensitivity}} and
\code{\link{run_metareg}}. See 'Value' in the functions above.}

\item{par}{A vector of three character strings that refer to three monitored
parameters in \code{jagsfit} which is an object of S3 class
\code{\link{run_model}}, \code{\link{run_ume}} and
\code{\link{run_metareg}}. These three selected parameters will be
considered in the diagnostic plots (see 'Value'). This argument will be
ignored for objects of S3 class \code{\link{run_series_meta}},
\code{\link{run_nodesplit}}, or \code{\link{run_sensitivity}}.}
}
\value{
\code{mcmc_diagnostics} returns a data-frame that contains the
  Gelman-Rubin convergence diagnostic, R-hat, and convergence status of the
  following monitored parameters:
  \tabular{ll}{
   \code{EM} \tab The estimated summary effect measure.\cr
   \tab \cr
   \code{EM_pred} \tab The predicted summary effect measure.\cr
   \tab \cr
   \code{delta} \tab The estimated trial-specific effect measure.\cr
   \tab \cr
   \code{tau} \tab The between-trial standard deviation.\cr
   \tab \cr
   \code{direct} \tab The direct estimate of the split node
   (see 'Value' in \code{\link{run_nodesplit}}).\cr
   \tab \cr
   \code{indirect} \tab The indirect estimate of the split node
   (see 'Value' in \code{\link{run_nodesplit}}).\cr
   \tab \cr
   \code{IF} \tab The inconsistency factor of the split node
   (see 'Value' in \code{\link{run_nodesplit}}).\cr
   \tab \cr
   \code{phi} \tab The informative missingness parameter.\cr
   \tab \cr
   \code{beta} \tab The regression coefficient.\cr
  }
  \code{mcmc_diagnostics} also uses the \code{\link[mcmcplots]{mcmcplot}}
  function to create an HTML file with a panel of diagnostic plots
  (trace, density, and autocorrelation) for each monitored parameter.
}
\description{
Evaluates whether convergence has been achieved for the
  monitored parameters of the Bayesian models. The Gelman-Rubin convergence
  diagnostic and relevant diagnostic plots are applied.
}
\details{
For each monitored parameter, \code{mcmc_diagnostics} considers the
  maximum R-hat and compares it with the threshold 1.1: convergence is
  achieved for the monitored parameter, when the maximum R-hat is below that
  threshold; otherwise, the Markov Chain Monte Carlo algorithm has not
  converged for that parameter. If the monitored parameter is a vector with
  the posterior results, there is only one R-hat. If the monitored parameter
  is a matrix of the posterior results, there are as many R-hats as the
  number of rows for that parameter.
}
\examples{
data("nma.baker2009")

# Read results from 'run_nodesplit' (using the default arguments)
res <- readRDS(system.file('extdata/node_baker.rds', package = 'rnmamod'))

# Obtain the diagnostic plots and check convergence based on R-hat
mcmc_diagnostics(net = res,
                 par = c("tau", "EM[2,1]", "EM.pred[2,1]"))

}
\references{
Gelman, A, Rubin, DB. Inference from iterative simulation using multiple
sequences. \emph{Stat Sci} 1992;\bold{7}:457--472.
}
\seealso{
\code{\link[mcmcplots]{mcmcplot}}, \code{\link{run_metareg}},
  \code{\link{run_model}}, \code{\link{run_nodesplit}},
  \code{\link{run_sensitivity}}, \code{\link{run_series_meta}},
  \code{\link{run_ume}}
}
\author{
{Loukia M. Spineli}
}
