% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterplots.deviance_function.R
\name{scatterplots_dev}
\alias{scatterplots_dev}
\title{Deviance scatterplot}
\usage{
scatterplots_dev(full, ume, colour)
}
\arguments{
\item{full}{A numeric vector with the posterior mean of deviance obtained
using the consistency model (see 'Value' in \code{\link{run_model}}).}

\item{ume}{A numeric vector with the posterior mean of deviance obtained
using the unrelated mean effects model (see 'Value' in
\code{\link{run_ume}}).}

\item{colour}{A string to define the colour of the points in the plot.}
}
\value{
A scatterplot of the posterior mean deviance contribution of the
  individual data points from the unrelated mean effects model against those
  from the consistency model. Each data point corresponds to a trial-arm
  indicated by a pair of numbers. The first number refers to the position
  of the trial in the dataset, and the second number refers to the
  corresponding trial-arm (see 'Arguments' and 'Value' in
  \code{\link{data_preparation}}).
}
\description{
Illustrates the posterior mean of deviance contribution of the
  individual data points under the unrelated mean effects model (via
  \code{\link{run_ume}}) against the posterior mean of deviance contribution
  under the consistency model (via \code{\link{run_model}}).
}
\details{
\code{scatterplots_dev} is integrated in the \code{\link{ume_plot}}
  function to compare the models regarding the posterior mean of deviance.
  This scatterplot has also been considered by Dias et al., (2013).
  When the majority of data points are scattered across the diagonal line,
  we may conclude that the compared models have a good agreement. Data points
  systematically scattered above and below the diagonal line may
  contribute more to the poor fit of the unrelated mean effects model and the
  consistency model, respectively.
}
\references{
Dias S, Welton NJ, Sutton AJ, Caldwell DM, Lu G, Ades AE. Evidence synthesis
for decision making 4: inconsistency in networks of evidence based on
randomized controlled trials.
\emph{Med Decis Making} 2013a;\bold{33}(5):641--56.
\doi{10.1177/0272989X12455847}
}
\seealso{
\code{\link{data_preparation}}, \code{\link{run_model}},
  \code{\link{run_ume}}, \code{\link{ume_plot}}
}
\author{
{Loukia M. Spineli}
}
