% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ne_countries.R
\name{ne_countries}
\alias{ne_countries}
\alias{ne_admin0}
\title{Get natural earth world country polygons}
\usage{
ne_countries(
  scale = 110,
  type = "countries",
  continent = NULL,
  country = NULL,
  geounit = NULL,
  sovereignty = NULL,
  returnclass = c("sp", "sf")
)
}
\arguments{
\item{scale}{scale of map to return, one of \code{110}, \code{50}, \code{10}
or \code{'small'}, \code{'medium'}, \code{'large'}}

\item{type}{country type, one of 'countries', 'map_units', 'sovereignty',
'tiny_countries'}

\item{continent}{a character vector of continent names to get countries from.}

\item{country}{a character vector of country names.}

\item{geounit}{a character vector of geounit names.}

\item{sovereignty}{a character vector of sovereignty names.}

\item{returnclass}{'sp' default or 'sf' for Simple Features}
}
\value{
\code{SpatialPolygonsDataFrame},\code{SpatialPointsDataFrame} or
\code{sf}
}
\description{
returns world country polygons at a specified scale, or points of
tiny_countries
}
\examples{
spdf_world <- ne_countries()
spdf_africa <- ne_countries(continent = "africa")
spdf_france <- ne_countries(country = "france")

if (require(sp)) {
  plot(spdf_world)
  plot(spdf_africa)
  plot(spdf_france)
}

# get as sf
if (require(sf)) {
  sf_world <- ne_countries(returnclass = "sf")
  plot(sf_world)
}

if (require(rnaturalearthdata) & require(sp)) {
  spdf_tiny_countries <- ne_countries(type = "tiny_countries", scale = 50)
  plot(spdf_tiny_countries)
}

}
