% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ne_states.r
\name{ne_states}
\alias{ne_states}
\alias{ne_admin1}
\title{Get natural earth world state (admin level 1) polygons}
\usage{
ne_states(country = NULL, geounit = NULL, iso_a2 = NULL, spdf = NULL,
  returnclass = c("sp", "sf"))
}
\arguments{
\item{country}{a character vector of country names.}

\item{geounit}{a character vector of geounit names.}

\item{iso_a2}{a character vector of iso_a2 country codes}

\item{spdf}{an optional alternative states map}

\item{returnclass}{'sp' default or 'sf' for Simple Features}
}
\value{
\code{SpatialPolygonsDataFrame} or \code{sf}
}
\description{
returns state polygons (administrative level 1) for specified countries
}
\examples{

# comparing using country and geounit to filter
if (requireNamespace("rnaturalearthhires")) {
  spdf_france_country <- ne_states(country = 'france')
  spdf_france_geounit <- ne_states(geounit = 'france')
  if (require(sp)) {
     plot(spdf_france_country)
     plot(spdf_france_geounit) 
  
     plot(ne_states(country = 'united kingdom'))  
     plot(ne_states(geounit = 'england'))  
  }
}
}
