% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commonStatsAndPlots.R
\docType{methods}
\name{plotInteractionsAverage}
\alias{plotInteractionsAverage}
\alias{plotInteractionsAverage,rnaCrosslinkDataSet-method}
\title{Plots a contact map of interactions of all samples of an RNA (interactor) on the RNA of interest}
\usage{
plotInteractionsAverage(
  cds,
  rna,
  interactor,
  directory = 0,
  a = 1,
  b = 50,
  c = 1,
  d = 50,
  h = 3
)
}
\arguments{
\item{cds}{A rnaCrosslinkDataSet object}

\item{rna}{The RNA of interest}

\item{interactor}{The RNA to show interactions with}

\item{directory}{An output directory for the heatmap (use 0 for no output)}

\item{a}{To make a subsetted plot (left value on x)}

\item{b}{To make a subsetted plot (right value on x) (use 'max' to plot the whole RNA strand length)}

\item{c}{To make a subsetted plot (left value on y)}

\item{d}{To make a subsetted plot (right value on y) (use 'max' to plot the whole RNA strand length)}

\item{h}{Height of image (inches) (only useful if plotting)}
}
\value{
A heatmap of interactions of all samples of the RNA (interactor) on the RNA of interest
}
\description{
Plots a contact map of interactions of all samples of an RNA (interactor) on the RNA of interest
}
\examples{
cds = makeExamplernaCrosslinkDataSet()

plotInteractionsAverage(cds,
            rna = "transcript1",
            interactor = "transcript2",
            b = "max",
            d = "max")
}
