% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Glm.r
\name{Glm}
\alias{Glm}
\title{rms Version of glm}
\usage{
Glm(
  formula,
  family = gaussian,
  data = environment(formula),
  weights,
  subset,
  na.action = na.delete,
  start = NULL,
  offset = NULL,
  control = glm.control(...),
  model = TRUE,
  method = "glm.fit",
  x = FALSE,
  y = TRUE,
  contrasts = NULL,
  ...
)
}
\arguments{
\item{formula, family, data, weights, subset, na.action, start, offset, control, model, method, x, y, contrasts}{see \code{\link[stats:glm]{stats::glm()}}; for \code{print} \code{x} is the result of \code{Glm}}

\item{...}{ignored
model coefficients, standard errors, etc.  Specify \code{coefs=n} to print
only the first \code{n} regression coefficients in the model.}
}
\value{
a fit object like that produced by \code{\link[stats:glm]{stats::glm()}} but with
\code{rms} attributes and a \code{class} of \code{"rms"}, \code{"Glm"},
\code{"glm"}, and \code{"lm"}.  The \code{g} element of the fit object is
the \eqn{g}-index.
}
\description{
This function saves \code{rms} attributes with the fit object so that
\code{anova.rms}, \code{Predict}, etc. can be used just as with \code{ols}
and other fits.  No \code{validate} or \code{calibrate} methods exist for
\code{Glm} though.
}
\details{
For the \code{print} method, format of output is controlled by the user
previously running \code{options(prType="lang")} where \code{lang} is
\code{"plain"} (the default), \code{"latex"}, or \code{"html"}.
}
\examples{

## Dobson (1990) Page 93: Randomized Controlled Trial :
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
f <- glm(counts ~ outcome + treatment, family=poisson())
f
anova(f)
summary(f)
f <- Glm(counts ~ outcome + treatment, family=poisson())
# could have had rcs( ) etc. if there were continuous predictors
f
anova(f)
summary(f, outcome=c('1','2','3'), treatment=c('1','2','3'))

}
\seealso{
\code{\link[stats:glm]{stats::glm()}},\code{\link[Hmisc:GiniMd]{Hmisc::GiniMd()}}, \code{\link[=prModFit]{prModFit()}}, \link[stats:glm.summaries]{stats::residuals.glm}
}
\keyword{models}
\keyword{regression}
