% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_generics.R
\name{plot.Rmonad}
\alias{plot.Rmonad}
\title{Render an Rmonad graph}
\usage{
\method{plot}{Rmonad}(x, y, label = NULL, color = "status", ...)
}
\arguments{
\item{x}{An Rmonad object}

\item{y}{This variable is currently ignored}

\item{label}{The node labels. If NULL, the node labels will equal node ids.
It may be one of the strings ['code', 'time', 'space', 'value', 'depth']. If
'value' is selected, nodes with no value cached are represented with '-'.
Alternatively, it may be a function that maps a single Rmonad object to a
string.}

\item{color}{How to color the nodes. Default is 'status', which colors green
for passing, orange for warning, and red for error. Alternatively, color can
be a function of an Rmonad object, which will be applied to each node.}

\item{...}{Additional arguments (unused currently)}
}
\description{
Convert the Rmonad object to a DiagrammeR graph and then render it
}
\details{
The nodes in the graph represent both a function and the function's output.
The edges are relationships between nodes. In an unnested pipeline, every
edge represents data flow from source to sink (solid black edges). Nested
pipelines contain two additional edge types: a transitive edge, where a node
is dependent on a value that was passed to its parent (dotted grey line);
and a nest edge linking a node to the nested node that produced its value
(solid red line).
}
