% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateMDCEV.R
\name{SummaryDemand}
\alias{SummaryDemand}
\title{SummaryDemand}
\usage{
SummaryDemand(demand, ci = 0.95)
}
\arguments{
\item{demand}{list of welfare changes from SimulateDemand}

\item{ci}{confidence interval (for 95\% input 0.95)}
}
\value{
demand_sum summary table of demand results
}
\description{
Provide a summary of demands each policy
}
\examples{
\donttest{
data(data_rec, package = "rmdcev")
mdcev_est <- FitMDCEV(psi_formula = ~ 1,
data = subset(data_rec, id < 500),
model = "hybrid0",
algorithm = "MLE")

policies <- CreateBlankPolicies(npols = 2,
ngoods = mdcev_est[["stan_data"]][["J"]],
dat_psi = mdcev_est[["stan_data"]][["dat_psi"]],
price_change_only = TRUE)

df_sim <- PrepareSimulationData(mdcev_est, policies)

wtp <- SimulateMDCEV(df_sim$df_indiv, df_common = df_sim$df_common,
sim_options = df_sim$sim_options,
cond_err = 1, nerrs = 5, sim_type = "demand")
SummaryDemand(wtp)
}
}
