% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions_main.R
\name{plot_decision_curve}
\alias{plot_decision_curve}
\title{Plot the net benefit curves from a decision_curve object or many decision_curve objects}
\usage{
plot_decision_curve(x, curve.names, cost.benefit.axis = TRUE,
  n.cost.benefits = 6, cost.benefits, standardize = TRUE,
  confidence.intervals, col, lty, lwd = 2, xlim, ylim, xlab, ylab,
  cost.benefit.xlab, legend.position = c("topright", "right", "bottomright",
  "bottom", "bottomleft", "left", "topleft", "top", "none"), ...)
}
\arguments{
\item{x}{'decision_curve' object to plot or a list of 'decision_curve' objects. Assumes output from function 'decision_curve'}

\item{curve.names}{vector of names to use when plotting legends.}

\item{cost.benefit.axis}{logical (default TRUE) indicating whether to print an additional x-axis showing relative cost:benefit ratios in addition to risk thresholds.}

\item{n.cost.benefits}{number of cost:benefit ratios to print if cost.benefit.axis = TRUE (default n.cost.benefit = 6).}

\item{cost.benefits}{Character vector of the form c("c1:b1", "c2:b2", ..., "cn:bn") with integers ci, bi corresponding to specific cost:benefit ratios to print. Default allows the function to calculate these automatically.}

\item{standardize}{logical (default TRUE) indicating whether to use the standardized net benefit (NB/disease prevalence) or not.}

\item{confidence.intervals}{logical indicating whether to plot confidence intervals.}

\item{col}{vector of color names to be used in plotting corresponding to the 'predictors' given. Default colors will be chosen from rainbow(..., v = .8). See details for more information on plot parameters.}

\item{lty}{vector of linetypes.}

\item{lwd}{vector of linewidths.}

\item{xlim}{vector giving c(min, max) of x-axis. Defaults to c(min(thresholds), max(thresholds)).}

\item{ylim}{vector giving c(min, max) of y-axis.}

\item{xlab}{label of main x-axis.}

\item{ylab}{label of y-axis.}

\item{cost.benefit.xlab}{label of cost:benefit ratio axis.}

\item{legend.position}{character vector giving position of legend. Options are "topright" (default), "right", "bottomright", "bottom", "bottomleft", "left", "topleft", "top", or "none".}

\item{...}{other options directly send to plot()}
}
\description{
Plot the net benefit curves from a decision_curve object or many decision_curve objects
}
\details{
When k decision_curve objects are input, the first k elements of col, lty, lwd ... correspond to the curves provided. The next two elements (..., k+1, k+2) correspond to the attributes of the 'all' and 'none' curves. See below for an example.
}
\examples{
data(dcaData)
set.seed(123)
baseline.model <- decision_curve(Cancer~Age + Female + Smokes,
                                data = dcaData,
                                thresholds = seq(0, .4, by = .005),
                                bootstraps = 10)

#plot using the defaults
plot_decision_curve(baseline.model,  curve.names = "baseline model")

set.seed(123)
full.model <- decision_curve(Cancer~Age + Female + Smokes + Marker1 + Marker2,
                            data = dcaData,
                            thresholds = seq(0, .4, by = .005),
                            bootstraps = 10)

# for lwd, the first two positions correspond to the decision curves, then 'all' and 'none'
plot_decision_curve( list(baseline.model, full.model),
                    curve.names = c("Baseline model", "Full model"),
                    col = c("blue", "red"),
                    lty = c(1,2),
                    lwd = c(3,2, 2, 1),
                    legend.position = "bottomright")


plot_decision_curve( list(baseline.model, full.model),
                    curve.names = c("Baseline model", "Full model"),
                    col = c("blue", "red"),
                    confidence.intervals = FALSE,  #remove confidence intervals
                    cost.benefit.axis = FALSE, #remove cost benefit axis
                    legend.position = "none") #remove the legend

#Set specific cost:benefit ratios.

plot_decision_curve( list(baseline.model, full.model),
                    curve.names = c("Baseline model", "Full model"),
                    col = c("blue", "red"),
                    cost.benefits = c("1:1000", "1:4", "1:9", "2:3", "1:3"),
                    legend.position = "bottomright")

#Plot net benefit instead of standardize net benefit.

plot_decision_curve( list(baseline.model, full.model),
                    curve.names = c("Baseline model", "Full model"),
                    col = c("blue", "red"),
                    ylim = c(-0.05, 0.15), #set ylim
                    lty = c(2,1),
                    standardize = FALSE, #plot Net benefit instead of standardized net benefit
                   legend.position = "topright")


}
