% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clip_erase.R
\name{ms_erase}
\alias{ms_erase}
\title{Remove features or portions of features that fall inside a specified area}
\usage{
ms_erase(target, erase = NULL, bbox = NULL, force_FC = TRUE)
}
\arguments{
\item{target}{the target layer from which to remove portions. One of:
\itemize{
 \item \code{geo_json} or \code{character} points, lines, or polygons;
 \item \code{geo_list} points, lines, or polygons;
 \item \code{SpatialPolygons}, \code{SpatialLines}, \code{SpatialPoints}
 }}

\item{erase}{the erase layer (polygon). One of:
\itemize{
 \item \code{geo_json} or \code{character} polygons;
 \item \code{geo_list} polygons;
 \item \code{SpatialPolygons*}
}}

\item{bbox}{supply a bounding box instead of an erasing layer to remove from
the target layer. Supply as a numeric vector: \code{c(minX, minY, maxX, maxY)}.}

\item{force_FC}{should the output be forced to be a \code{FeatureCollection} even
if there are no attributes? Default \code{TRUE}.
 \code{FeatureCollections} are more compatible with \code{rgdal::readOGR} and
 \code{geojsonio::geojson_sp}. If \code{FALSE} and there are no attributes associated with
 the geometries, a \code{GeometryCollection} will be output. Ignored for \code{Spatial}
 objects, as the output is always the same class as the input.}
}
\value{
erased target in the same format as the input target
}
\description{
Removes portions of the target layer that fall inside the erasing layer or bounding box.
}
\examples{
library(geojsonio, quietly = TRUE)
library(sp)

points <- structure("{\\"type\\":\\"FeatureCollection\\",
  \\"features\\":[{\\"type\\":\\"Feature\\",\\"properties\\":{},
  \\"geometry\\":{\\"type\\":\\"Point\\",\\"coordinates\\":
  [52.8658,-44.7219]}},{\\"type\\":\\"Feature\\",\\"properties\\":{},
  \\"geometry\\":{\\"type\\":\\"Point\\",\\"coordinates\\":
  [53.7702,-40.4873]}},{\\"type\\":\\"Feature\\",\\"properties\\":{},
  \\"geometry\\":{\\"type\\":\\"Point\\",\\"coordinates\\":[55.3204,-37.5579]}},
  {\\"type\\":\\"Feature\\",\\"properties\\":{},\\"geometry\\":
  {\\"type\\":\\"Point\\",\\"coordinates\\":[56.2757,-37.917]}},
  {\\"type\\":\\"Feature\\",\\"properties\\":{},\\"geometry\\":
  {\\"type\\":\\"Point\\",\\"coordinates\\":[56.184,-40.6443]}},
  {\\"type\\":\\"Feature\\",\\"properties\\":{},\\"geometry\\":
  {\\"type\\":\\"Point\\",\\"coordinates\\":[61.0835,-40.7529]}},
  {\\"type\\":\\"Feature\\",\\"properties\\":{},\\"geometry\\":
  {\\"type\\":\\"Point\\",\\"coordinates\\":[58.0202,-43.634]}}]}", 
  class = c("json", "geo_json"))
points <- geojson_sp(points)

erase_poly <- structure('{
"type": "Feature",
"properties": {},
"geometry": {
"type": "Polygon",
"coordinates": [
[
[51, -40],
[55, -40],
[55, -45],
[51, -45],
[51, -40]
]
]
}
}', class = c("json", "geo_json"))
erase_poly <- geojson_sp(erase_poly)

out <- ms_erase(points, erase_poly)
plot(out, add = TRUE)

}

