% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-sim.R
\name{TC_CAR1_sc}
\alias{TC_CAR1_sc}
\title{A Wrap Function to analyze a Simulated Data - All Cases}
\usage{
TC_CAR1_sc(RFIanalysis, scenario, EE, DE, C.matrix, Subject, Time, Nboot,
  nrep, ncores, name_dir_sim = NULL, print.progress = FALSE,
  saveboot = FALSE)
}
\arguments{
\item{RFIanalysis}{the output from RFI RNA-seq dataset. In the ideal simulation case,
it is res from TC_CAR1, in the  misspecified case, it is res from TC_Symm}

\item{scenario}{either 2- 'Symm' or 1- 'CAR1'}

\item{EE}{number of EE genes}

\item{DE}{number of DE genes}

\item{C.matrix}{is a list of matrix Ci in testing H0:  Ci*beta = 0.}

\item{Subject}{a vector of subjects or experimental units.}

\item{Time}{a vector of time points.}

\item{Nboot}{number of bootstrap replicates, default is 100.}

\item{nrep}{index of sim replicate}

\item{ncores}{number of cores for embarrassingly parallel procedure. Default
value of \code{ncores} is 1.}

\item{name_dir_sim}{name of directory to contain the output and result of this function}

\item{print.progress}{\code{TRUE} or \code{FALSE}, printing the process or not.}

\item{saveboot}{\code{TRUE} or \code{FALSE} to save or not save bootstrap output}
}
\value{
R, V, FDR, PAUC, and AUC of all 7 methods (2 oracles with unshrunken and shrunken)
with FPR = 0.05, 0.10, 0.20 for each S, R, V, FDR, PAUC.
}
\description{
This function does the following: 1. Generating a simulated
counts data set consisting of EE  genes, and DE genes with
respect to some contrast from a ideal case, i.e., the counts
are generated from corCAR1 structure, or misspecified case, i.e., the counts
are generated from corSymm structure; analyzing this simulated data set
using  methods: \code{\link{TC_CAR1}},
 \code{\link{voomlimmaFit}}, \code{\link{edgeRFit}}
, \code{\link{DESeq2Fit}}.
}
\examples{
\donttest{
data(res)
data(resSymm)
data(design)
data(covset)
RFIanalysis <- list(CAR1 = res, Symm = resSymm)
C.matrix <- list()
# test for Line main effect
C.matrix[[1]] <- limma::makeContrasts(line2, levels = design)
names(C.matrix) <- c("line2")
scenario <- 1; EE <- 3; DE <- 2; ncores <- 1; Subject <- covset$ear;
Time <- covset$time; Nboot <- 2; nrep <- 1;
name_dir_sim <- NULL
print.progress <- FALSE; saveboot <- FALSE;
TC_Symm_scOut <- rmRNAseq:::TC_CAR1_sc(RFIanalysis, scenario,  EE, DE,  C.matrix,
Subject, Time,  Nboot,  nrep, ncores, name_dir_sim , print.progress, saveboot)
names(TC_Symm_scOut)
}
}
