% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multtest.R
\name{jabes.q}
\alias{jabes.q}
\title{Q-value Using Histogram-based Method}
\usage{
jabes.q(p, B = 20)
}
\arguments{
\item{p}{a numerical vector of p-value}

\item{B}{number of bin}
}
\value{
The function returns a q-value vector of the input p-value vector.
}
\description{
This function computes q-values using the approach of Nettleton et al.
(2006) JABES 11, 337-356.
}
\examples{
data(res)
p <- res$pqvalue$pv$line2
q <- rmRNAseq:::jabes.q(p)
sum(q <= .05)
}
\references{
1. Dan Nettleton, J. T. Gene Hwang, Rico A. Caldo and Roger P.
  Wise. Estimating the Number of True Null Hypotheses from a Histogram of p
  Values. Journal of Agricultural, Biological, and Environmental Statistics
  Vol. 11, No. 3 (Sep., 2006), pp. 337-356.
}
\author{
Dan Nettleton \email{dnett@iastate.edu}
}
