% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlistings.R
\name{split_into_pages_by_var}
\alias{split_into_pages_by_var}
\title{Split Listing by Values of a Variable}
\usage{
split_into_pages_by_var(lsting, var, page_prefix = var)
}
\arguments{
\item{lsting}{listing_df. The listing to split.}

\item{var}{character. Name of the variable to split on.}

\item{page_prefix}{character. Prefix to be appended with the split value (\code{var} level),
at the end of the subtitles, corresponding to each resulting list element (listing).}
}
\value{
A list of \code{lsting_df} objects each corresponding to a unique value of \code{var}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Split is performed based on unique values of the given parameter present in the listing.
Each listing can only be split by variable once. If this function is applied prior to
pagination, parameter values will be separated by page.
}
\note{
This function should only be used after the complete listing has been created. The
listing cannot be modified further after applying this function.
}
\examples{
dat <- ex_adae[1:20, ]

lsting <- as_listing(
  dat,
  key_cols = c("USUBJID", "AGE"),
  disp_cols = "SEX",
  main_title = "title",
  main_footer = "footer"
) \%>\%
  add_listing_col("BMRKR1", format = "xx.x") \%>\%
  split_into_pages_by_var("SEX")

lsting

}
