% Generated by roxygen2 (4.0.1): do not edit by hand
\name{equal}
\alias{equal}
\title{Compare two values and test whether they are equal at certain degree}
\usage{
equal(x, y, exactly = FALSE, include = FALSE, pattern = FALSE,
  dist = NA_integer_, ...)
}
\arguments{
\item{x}{target value}

\item{y}{source value (can be ignored in \code{list.search} expression)}

\item{exactly}{\code{TRUE} to test if \code{x} and \code{y} are
exactly identical. \code{...} will be passed to \code{identical}.}

\item{include}{\code{TRUE} to test if \code{x} included in \code{y}.}

\item{pattern}{\code{TRUE} to indicate \code{x} is a regular expression
pattern and test if \code{y} matches that pattern.
\code{...} will be passed to \code{grepl}.}

\item{dist}{\code{integer} to indicate the maximum string distance
in tolerance and test if \code{x} is close to \code{y} in the distance.
\code{...} will be passed to \code{stringdist::stringdist}.}

\item{...}{additional parameters}
}
\value{
\code{logical}
}
\description{
Compare two values and test whether they are equal at certain degree
}
\details{
\code{equal()} tests if two values are equal in certain sense. By default it
performs atomic equality test (\code{==}) between two atomic vectors with
the same mode and length unless any of the additional parameters is specified.

\code{exactly = }, \code{include = }, \code{pattern = }, and \code{dist = }
are mutually exlcusive and the former one always has higher priority than
the latter one, that is, if \code{exactly = TRUE} is specified then the last
three arguments will be ignored; or if \code{include = TRUE} is specified
then the last two arguments will be ignored, etc.
}

