% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSEA.R
\name{runGOEnrich}
\alias{runGOEnrich}
\title{Run Gene Ontology enrichment analysis on differentially expressed genes.}
\usage{
runGOEnrich(
  result,
  group = NULL,
  useBg = TRUE,
  orderBy = "padj",
  logFCThresh = 1,
  padjThresh = 0.05,
  splitReg = FALSE,
  ...
)
}
\arguments{
\item{result}{Data frame of unfiltered output from \code{\link{runMarkerDEG}}
or \code{\link{runPairwiseDEG}}.}

\item{group}{Selection of one group available from \code{result$group}.
Default \code{NULL} uses all groups involved in DE \code{result} table.}

\item{useBg}{Logical, whether to set all genes involved in DE analysis
(before threshold filtering) as a domain background of GO analysis. Default
\code{TRUE}.}

\item{orderBy}{Name of DE statistics metric to order the gene list for each
group. Choose from \code{"logFC"} (default), \code{"pval"} or \code{"padj"}.
Or set \code{NULL} to turn off ranked mode.}

\item{logFCThresh}{The log2FC threshold above which the genes will be used.
Default \code{1}.}

\item{padjThresh}{The adjusted p-value threshold less than which the genes
will be used. Default \code{0.05}.}

\item{splitReg}{Whether to have queries of both up-regulated and
down-regulated genes for each group. Default \code{FALSE} only queries
up-regulated genes and should be preferred when \code{result} comes from
marker detection test. When \code{result} comes from group-to-group DE test,
it is recommended to set \code{splitReg = TRUE}.}

\item{...}{Additional arguments passed to \code{gprofiler2::gost()}. Useful
ones are:

\describe{
\item{\code{organism}}{The organism to be used for the analysis. "hsapiens"
for human, "mmusculus" for mouse.}
\item{\code{evcodes}}{Whether to include overlapping genes for each term.
Default \code{FALSE}.}
\item{\code{significant}}{Whether to filter out non-significant terms.
Default \code{TRUE}.}
}
Arguments \code{query}, \code{custom_bg}, \code{domain_scope}, and
\code{ordered_query} are pre-specified by this wrapper function.}
}
\value{
A list object where each element is a result list for a group. Each
result list contains two elements:
\item{result}{data.frame of main GO analysis result.}
\item{meta}{Meta information for the query.}

See \code{gprofiler2::gost()}. for detailed explanation.
}
\description{
This function forms genesets basing on the differential expression result,
and calls gene ontology (GO) analysis method provided by gprofiler2.
}
\examples{
# Setting `significant = FALSE` because it's hard for a gene list obtained
# from small test dataset to represent real-life biology.
\donttest{
if (requireNamespace("gprofiler2", quietly = TRUE)) {
    go <- runGOEnrich(deg.pw, group = "0.stim", significant = FALSE)
}
}
}
\references{
Kolberg, L. et al, 2020 and Raudvere, U. et al, 2019
}
