% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{calcAlignment}
\alias{calcAlignment}
\title{Calculate alignment metric}
\usage{
calcAlignment(
  object,
  k = NULL,
  rand.seed = 1,
  cells.use = NULL,
  cells.comp = NULL,
  clusters.use = NULL,
  by.cell = FALSE,
  by.dataset = FALSE
)
}
\arguments{
\item{object}{\code{liger} object. Should call quantile_norm before calling.}

\item{k}{Number of nearest neighbors to use in calculating alignment. By default, this will be
floor(0.01 * total number of cells), with a lower bound of 10 in all cases except where the
total number of sampled cells is less than 10.}

\item{rand.seed}{Random seed for reproducibility (default 1).}

\item{cells.use}{Vector of cells across all datasets to use in calculating alignment}

\item{cells.comp}{Vector of cells across all datasets to compare to cells.use when calculating
alignment (instead of dataset designations). These can be from the same dataset as cells.use.
(default NULL)}

\item{clusters.use}{Names of clusters to use in calculating alignment (default NULL).}

\item{by.cell}{Return alignment calculated individually for each cell (default FALSE).}

\item{by.dataset}{Return alignment calculated for each dataset (default FALSE).}
}
\value{
Alignment metric.
}
\description{
This metric quantifies how well-aligned two or more datasets are. Alignment is defined as in the
documentation for Seurat. We randomly downsample all datasets to have as many cells as the
smallest one. We construct a nearest-neighbor graph and calculate for each cell how many of its
neighbors are from the same dataset. We average across all cells and compare to the expected
value for perfectly mixed datasets, and scale the value from 0 to 1. Note that in practice,
alignment can be greater than 1 occasionally.
}
\examples{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
ligerex <- selectGenes(ligerex)
ligerex <- scaleNotCenter(ligerex)
# Specification for minimal example run time, not converging
ligerex <- optimizeALS(ligerex, k = 5, max.iters = 1)
ligerex <- quantile_norm(ligerex)
agreement <- calcAlignment(ligerex)
}
