% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{readSubset}
\alias{readSubset}
\title{Sample data for plotting}
\usage{
readSubset(
  object,
  slot.use = "norm.data",
  balance = NULL,
  max.cells = 1000,
  chunk = 1000,
  datasets.use = NULL,
  genes.use = NULL,
  rand.seed = 1,
  verbose = TRUE
)
}
\arguments{
\item{object}{\code{liger} object. Should call normalize and selectGenes before calling.}

\item{slot.use}{Type of data for sampling (raw.data, norm.data(default), scale.data).}

\item{balance}{Type of sampling. NULL means that max_cells are sampled from among all cells;
balance="dataset" samples up to max_cells from each dataset;
balance="cluster" samples up to max_cells from each cluster.}

\item{max.cells}{Total number of cell to sample (default 5000).}

\item{chunk}{is the max number of cells at a time to read from disk (default 1000).}

\item{datasets.use}{uses only the specified datasets for sampling. Default is NULL (all datasets)}

\item{genes.use}{samples from only the specified genes. Default is NULL (all genes)}

\item{rand.seed}{for reproducibility (default 1).}

\item{verbose}{Print progress bar/messages (TRUE by default)}
}
\value{
\code{liger} object with sample.data slot set.
}
\description{
This function samples raw/normalized/scaled data from on-disk HDF5 files for plotting.
This function assumes that the cell barcodes are unique across all datasets.
}
\examples{
\dontrun{
# Only for online liger object (based on HDF5 files)
# Example: sample a total amount of 5000 cells from norm.data for downstream analysis 
ligerex <- readSubset(ligerex, slot.use = "norm.data", max.cells = 5000)
}
}
