% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NoiseKrigingClass.R
\name{as.list.NoiseKriging}
\alias{as.list.NoiseKriging}
\alias{as.list,NoiseKriging,NoiseKriging-method}
\title{Coerce a \code{NoiseKriging} Object into a List}
\usage{
\method{as.list}{NoiseKriging}(x, ...)
}
\arguments{
\item{x}{An object with class \code{"NoiseKriging"}.}

\item{...}{Ignored}
}
\value{
A list with its elements copying the content of the
    \code{NoiseKriging} object fields: \code{kernel}, \code{optim},
    \code{objective}, \code{theta} (vector of ranges),
    \code{sigma2} (variance), \code{X}, \code{centerX},
    \code{scaleX}, \code{y}, \code{centerY}, \code{scaleY},
    \code{regmodel}, \code{F}, \code{T}, \code{M}, \code{z},
    \code{beta}.
}
\description{
Coerce a \code{NoiseKriging} Object into a List
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + X/10 * rnorm(nrow(X)) # add noise dep. on X

k <- NoiseKriging(y, noise=(X/10)^2, X, kernel = "matern3_2")

l <- as.list(k)
cat(paste0(names(l), " =" , l, collapse = "\n"))
}
\author{
Yann Richet \email{yann.richet@asnr.fr}
}
