% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KrigingClass.R
\name{logLikelihoodFun.Kriging}
\alias{logLikelihoodFun.Kriging}
\alias{logLikelihoodFun,Kriging,Kriging-method}
\title{Compute Log-Likelihood of Kriging Model}
\usage{
\method{logLikelihoodFun}{Kriging}(
  object,
  theta,
  return_grad = FALSE,
  return_hess = FALSE,
  bench = FALSE,
  ...
)
}
\arguments{
\item{object}{An S3 Kriging object.}

\item{theta}{A numeric vector of (positive) range parameters at
which the log-likelihood will be evaluated.}

\item{return_grad}{Logical. Should the function return the gradient?}

\item{return_hess}{Logical. Should the function return Hessian?}

\item{bench}{Logical. Should the function display benchmarking output?}

\item{...}{Not used.}
}
\value{
The log-Likelihood computed for given
    \eqn{\boldsymbol{theta}}{\theta}.
}
\description{
Compute Log-Likelihood of Kriging Model
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X)

k <- Kriging(y, X, kernel = "matern3_2")
print(k)

ll <- function(theta) logLikelihoodFun(k, theta)$logLikelihood

t <- seq(from = 0.001, to = 2, length.out = 101)
plot(t, ll(t), type = 'l')
abline(v = k$theta(), col = "blue")
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
