% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KMClass.R
\name{update,KM-method}
\alias{update,KM-method}
\title{Update a \code{KM} Object with New Points}
\usage{
\S4method{update}{KM}(
  object,
  newX,
  newy,
  newX.alreadyExist = FALSE,
  cov.reestim = TRUE,
  trend.reestim = cov.reestim,
  nugget.reestim = FALSE,
  newnoise.var = NULL,
  kmcontrol = NULL,
  newF = NULL,
  ...
)
}
\arguments{
\item{object}{A KM object.}

\item{newX}{A numeric matrix containing the new design points. It
must have \code{object@d} columns in correspondence with those
of the design matrix used to fit the model which is stored as
\code{object@X}.}

\item{newy}{A numeric vector of new response values, in
correspondence with the rows of \code{newX}.}

\item{newX.alreadyExist}{Logical. If TRUE, \code{newX} can contain
some input points that are already in \code{object@X}.}

\item{cov.reestim}{Logical. If \code{TRUE}, the vector
\code{theta} of correlation ranges will be re-estimated using
the new observations as well as the observations already used
when fitting \code{object}. Only \code{TRUE} can be used for
now.}

\item{trend.reestim}{Logical. If \code{TRUE} the vector
\code{beta} of trend coefficients will be re-estimated using
all the observations. Only \code{TRUE} can be used for now.}

\item{nugget.reestim}{Logical. If \code{TRUE} the nugget effect
will be re-estimated using all the observations. Only
\code{FALSE} can be used for now.}

\item{newnoise.var}{Optional variance of an additional noise on
the new response.}

\item{kmcontrol}{A list of options to tune the fit. Not available
yet.}

\item{newF}{New trend matrix. XXXY?}

\item{...}{Ignored.}
}
\value{
The updated \code{KM} object.
}
\description{
The \code{update} method is used when new observations are added
to a fitted kriging model. Rather than fitting the model from
scratch with the updated observations added, the results of the
fit as stored in \code{object} are used to achieve some savings.
}
\details{
Without a dedicated \code{update} method for the class
\code{"KM"}, this would have been inherited from the class
\code{"km"}. The dedicated method is expected to run faster.  A
comparison can be made by coercing a \code{KM} object to a
\code{km} object with \code{\link{as.km}} before calling
\code{update}.
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
plot(f)
set.seed(123)
X <- as.matrix(runif(5))
y <- f(X)
points(X, y, col = "blue")
KMobj <- KM(design = X, response = y,covtype = "gauss")
x <-  seq(from = 0, to = 1, length.out = 101)
p_x <- predict(KMobj, x)
lines(x, p_x$mean, col = "blue")
lines(x, p_x$lower95, col = "blue")
lines(x, p_x$upper95, col = "blue")
newX <- as.matrix(runif(3))
newy <- f(newX)
points(newX, newy, col = "red")

## replace the object by its udated version
KMobj <- update(KMobj, newX=newX, newy=newy)

x <- seq(from = 0, to = 1, length.out = 101)
p2_x <- predict(KMobj, x)
lines(x, p2_x$mean, col = "red")
lines(x, p2_x$lower95, col = "red")
lines(x, p2_x$upper95, col = "red")

}
\seealso{
\code{\link{as.km}} to coerce a \code{KM} object to the
    class \code{"km"}.
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
