% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NoiseKrigingClass.R
\name{logLikelihoodFun.NoiseKriging}
\alias{logLikelihoodFun.NoiseKriging}
\alias{logLikelihoodFun,NoiseKriging,NoiseKriging-method}
\title{Compute Log-Likelihood of NoiseKriging Model}
\usage{
\method{logLikelihoodFun}{NoiseKriging}(object, theta_sigma2, return_grad = FALSE, bench = FALSE, ...)
}
\arguments{
\item{object}{An S3 NoiseKriging object.}

\item{theta_sigma2}{A numeric vector of (positive) range parameters and variance at
which the log-likelihood will be evaluated.}

\item{return_grad}{Logical. Should the function return the gradient?}

\item{bench}{Logical. Should the function display benchmarking output}

\item{...}{Not used.}
}
\value{
The log-Likelihood computed for given
    \eqn{\boldsymbol{theta_sigma2}}{\theta,\sigma^2}.
}
\description{
Compute Log-Likelihood of NoiseKriging Model
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + X/10  *rnorm(nrow(X))

k <- NoiseKriging(y, (X/10)^2, X, kernel = "matern3_2")
print(k)

theta0 = k$theta()
ll_sigma2 <- function(sigma2) logLikelihoodFun(k, cbind(theta0,sigma2))$logLikelihood
s2 <- seq(from = 0.001, to = 1, length.out = 101)
plot(s2, Vectorize(ll_sigma2)(s2), type = 'l')
abline(v = k$sigma2(), col = "blue")

sigma20 = k$sigma2()
ll_theta <- function(theta) logLikelihoodFun(k, cbind(theta,sigma20))$logLikelihood
t <- seq(from = 0.001, to = 2, length.out = 101)
plot(t, Vectorize(ll_theta)(t), type = 'l')
abline(v = k$theta(), col = "blue")

ll <- function(theta_sigma2) logLikelihoodFun(k, theta_sigma2)$logLikelihood
s2 <- seq(from = 0.001, to = 1, length.out = 31)
t <- seq(from = 0.001, to = 2, length.out = 31)
contour(t,s2,matrix(ncol=length(s2),ll(expand.grid(t,s2))),xlab="theta",ylab="sigma2")
points(k$theta(),k$sigma2(),col='blue')
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
