test_that("Max Perfect Checking", {
  s <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
  t <- c(4, 5, 6, 4, 5, 6, 4, 5, 6)
  d <- c(1, 2, 3, 4, 5, 6, 7, 8, 9)
  out <- MaximumWeightPerfectMatchingRunner(s, t, d, 6)
  expect_equal(out[[1]], 15)
  expect_equal(out[[2]], list(c(1, 4), c(2, 5), c(3, 6)))
  out <- MaxMatching(s, t, d, 6, "MaxWeightedPerfectMatching")
  expect_equal(out[[1]], 15)
  expect_equal(out[[2]], list(c(1, 4), c(2, 5), c(3, 6)))
  expect_error(MaxMatching(s, t, d, 6, "abc"), "Invalid")
})

test_that("Max Fractional Perfect Checking", {
  s <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
  t <- c(4, 5, 6, 4, 5, 6, 4, 5, 6)
  d <- c(1, 2, 3, 4, 5, 6, 7, 8, 9)
  out <- MaximumWeightFractionalPerfectMatchingRunner(s, t, d, 6)
  expect_equal(out[[1]], 30)
  expect_equal(out[[2]], list(c(1, 4), c(2, 5), c(3, 6)))
  out <- MaxMatching(s, t, d, 6, "MaxWeightedPerfectFractionalMatching")
  expect_equal(out[[1]], 30)
  expect_equal(out[[2]], list(c(1, 4), c(2, 5), c(3, 6)))
  expect_error(MaxMatching(s, t, d, 6, "abc"), "Invalid")
})

test_that("Max Weight Fractional Checking", {
  s <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
  t <- c(4, 5, 6, 4, 5, 6, 4, 5, 6)
  d <- c(1, 2, 3, 4, 5, 6, 7, 8, 9)
  out <- MaximumWeightFractionalMatchingRunner(s, t, d, 6)
  expect_equal(out[[1]], 30)
  expect_equal(out[[2]], list(c(1, 4), c(2, 5), c(3, 6)))
  out <- MaxMatching(s, t, d, 6, "MaxWeightedFractionalMatching")
  expect_equal(out[[1]], 30)
  expect_equal(out[[2]], list(c(1, 4), c(2, 5), c(3, 6)))
  expect_error(MaxMatching(s, t, d, 6, "abc"), "Invalid")
})

test_that("Max Weight Checking", {
  s <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
  t <- c(4, 5, 6, 4, 5, 6, 4, 5, 6)
  d <- c(1, 2, 3, 4, 5, 6, 7, 8, 9)
  out <- MaximumWeightMatchingRunner(s, t, d, 6)
  expect_equal(out[[1]], 15)
  expect_equal(out[[2]], list(c(1, 4), c(2, 5), c(3, 6)))
  out <- MaxMatching(s, t, d, 6, "MaxWeightedMatching")
  expect_equal(out[[1]], 15)
  expect_equal(out[[2]], list(c(1, 4), c(2, 5), c(3, 6)))
  expect_error(MaxMatching(s, t, d, 6, "abc"), "Invalid")
})

test_that("Max Cardinality Checking", {
  s <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
  t <- c(4, 5, 6, 4, 5, 6, 4, 5, 6)
  d <- c(1, 2, 3, 4, 5, 6, 7, 8, 9)
  out <- MaximumCardinalityMatchingRunner(s, t, 6)
  expect_equal(out[[2]], list(c(1, 4), c(2, 5), c(3, 6)))
  out <- MaxCardinalityMatching(s, t, 6, "MaxMatching")
  expect_equal(out[[2]], list(c(1, 4), c(2, 5), c(3, 6)))
  expect_error(MaxCardinalityMatching(s, t, 6, "abc"), "Invalid")
})

test_that("Max Cardinality Fractional Checking", {
  s <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
  t <- c(4, 5, 6, 4, 5, 6, 4, 5, 6)
  d <- c(1, 2, 3, 4, 5, 6, 7, 8, 9)
  out <- MaximumCardinalityFractionalMatchingRunner(s, t, 6)
  expect_equal(out[[2]], list(c(1, 6), c(2, 5), c(3, 4)))
  out <- MaxCardinalityMatching(s, t, 6, "MaxFractionalMatching")
  expect_equal(out[[2]], list(c(1, 6), c(2, 5), c(3, 4)))
  expect_error(MaxCardinalityMatching(s, t, 6, "abc"), "Invalid")
})
