% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/las_specifications.r
\name{las_specification_tools}
\alias{las_specification_tools}
\alias{is_defined_offsets}
\alias{is_valid_offsets}
\alias{is_defined_scalefactors}
\alias{is_valid_scalefactors}
\alias{is_defined_filesourceid}
\alias{is_valid_filesourceid}
\alias{is_defined_globalencoding}
\alias{is_valid_globalencoding}
\alias{is_defined_version}
\alias{is_valid_version}
\alias{is_defined_date}
\alias{is_valid_date}
\alias{is_defined_pointformat}
\alias{is_valid_pointformat}
\alias{is_defined_extrabytes}
\alias{is_valid_extrabytes}
\alias{is_empty_point_cloud}
\alias{is_defined_coordinates}
\alias{is_valid_XYZ}
\alias{is_valid_Intensity}
\alias{is_valid_ReturnNumber}
\alias{is_valid_NumberOfReturns}
\alias{is_valid_ScanDirectionFlag}
\alias{is_valid_EdgeOfFlightline}
\alias{is_valid_Classification}
\alias{is_valid_ScannerChannel}
\alias{is_valid_SyntheticFlag}
\alias{is_valid_KeypointFlag}
\alias{is_valid_WithheldFlag}
\alias{is_valid_OverlapFlag}
\alias{is_valid_ScanAngle}
\alias{is_valid_ScanAngleRank}
\alias{is_valid_UserData}
\alias{is_valid_gpstime}
\alias{is_valid_PointSourceID}
\alias{is_valid_RGB}
\alias{is_valid_NIR}
\alias{is_compliant_ReturnNumber}
\alias{is_compliant_NumberOfReturns}
\alias{is_compliant_ReturnNumber_vs_NumberOfReturns}
\alias{is_compliant_RGB}
\alias{is_compliant_ScanAngle}
\alias{is_compliant_ScanAngleRank}
\alias{is_NIR_in_valid_format}
\alias{is_gpstime_in_valid_format}
\alias{is_RGB_in_valid_format}
\alias{is_ScanAngle_in_valid_format}
\alias{is_ScannerChannel_in_valid_format}
\alias{is_XY_larger_than_bbox}
\alias{is_XY_smaller_than_bbox}
\alias{is_Z_in_bbox}
\alias{is_number_of_points_in_accordance_with_header}
\alias{is_number_of_points_by_return_in_accordance_with_header}
\alias{is_extrabytes_in_accordance_with_data}
\title{A set of function to test conformance with LAS specifications}
\usage{
is_defined_offsets(header, behavior = "bool")

is_valid_offsets(header, behavior = "bool")

is_defined_scalefactors(header, behavior = "bool")

is_valid_scalefactors(header, behavior = "bool")

is_defined_filesourceid(header, behavior = "bool")

is_valid_filesourceid(header, behavior)

is_defined_globalencoding(header, behavior = "bool")

is_valid_globalencoding(header, behavior = "bool")

is_defined_version(header, behavior = "bool")

is_valid_version(header, behavior = "bool")

is_defined_date(header, behavior = "bool")

is_valid_date(header, behavior = "bool")

is_defined_pointformat(header, behavior = "bool")

is_valid_pointformat(header, behavior = "bool")

is_defined_extrabytes(header, behavior = "bool")

is_valid_extrabytes(header, behavior = "bool")

is_empty_point_cloud(header, behavior = "bool")

is_defined_coordinates(data, behavior = "bool")

is_valid_XYZ(data, behavior = "bool")

is_valid_Intensity(data, behavior = "bool")

is_valid_ReturnNumber(data, header, behavior = "bool")

is_valid_NumberOfReturns(data, header, behavior = "bool")

is_valid_ScanDirectionFlag(data, behavior = "bool")

is_valid_EdgeOfFlightline(data, behavior = "bool")

is_valid_Classification(data, header, behavior = "bool")

is_valid_ScannerChannel(data, behavior = "bool")

is_valid_SyntheticFlag(data, behavior = "bool")

is_valid_KeypointFlag(data, behavior = "bool")

is_valid_WithheldFlag(data, behavior = "bool")

is_valid_OverlapFlag(data, behavior = "bool")

is_valid_ScanAngle(data, behavior = "bool")

is_valid_ScanAngleRank(data, behavior = "bool")

is_valid_UserData(data, behavior = "bool")

is_valid_gpstime(data, behavior = "bool")

is_valid_PointSourceID(data, behavior = "bool")

is_valid_RGB(data, behavior = "bool")

is_valid_NIR(data, behavior = "bool")

is_compliant_ReturnNumber(data, behavior = "bool")

is_compliant_NumberOfReturns(data, behavior = "bool")

is_compliant_ReturnNumber_vs_NumberOfReturns(data, behavior = "bool")

is_compliant_RGB(data, behavior = "bool")

is_compliant_ScanAngle(data, behavior = "bool")

is_compliant_ScanAngleRank(data, behavior = "bool")

is_NIR_in_valid_format(header, data, behavior = "bool")

is_gpstime_in_valid_format(header, data, behavior = "bool")

is_RGB_in_valid_format(header, data, behavior = "bool")

is_ScanAngle_in_valid_format(header, data, behavior = "bool")

is_ScannerChannel_in_valid_format(header, data, behavior = "bool")

is_XY_larger_than_bbox(header, data, behavior = "bool")

is_XY_smaller_than_bbox(header, data, behavior = "bool")

is_Z_in_bbox(header, data, behavior = "bool")

is_number_of_points_in_accordance_with_header(header, data, behavior = "bool")

is_number_of_points_by_return_in_accordance_with_header(
  header,
  data,
  behavior = "bool"
)

is_extrabytes_in_accordance_with_data(header, data, behavior = "bool")
}
\arguments{
\item{header}{a list containing the header of a las file}

\item{behavior}{character. Defines the behavior of the function. 'bool' returns TRUE or FALSE.
'warning' throw a warning for each fails and return FALSE if any warning TRUE otherwise. 'vector' returns a
character vector of each warning but does not thrown any warning.}

\item{data}{a data.frame or a data.table containing a point cloud}
}
\description{
A set of function to test conformance with \href{http://www.asprs.org/wp-content/uploads/2019/07/LAS_1_4_r15.pdf}{LAS specification}.
Tools reserved to developpers and not intended to be used by regular users. The functions return TRUE
or FALSE by default without more information. If behavior is 'warning' functions throw a warning
for each fail and return FALSE if any warning TRUE otherwise. If behavior is 'stop' functions throw
an error for the first fail and return TRUE if 0 error. If behavior is 'vector' returns a
character vector with the decription of each error an never fail. Is it useful to make a detailed
inspection.
}
