% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn.R
\name{as_function}
\alias{as_function}
\alias{is_lambda}
\alias{as_closure}
\title{Convert to function or closure}
\usage{
as_function(x, env = caller_env())

is_lambda(x)

as_closure(x, env = caller_env())
}
\arguments{
\item{x}{A function or formula.

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function
with up to two arguments: \code{.x} (single argument) or \code{.x} and \code{.y}
(two arguments). The \code{.} placeholder can be used instead of \code{.x}.
This allows you to create very compact anonymous functions (lambdas) with up
to two inputs. Functions created from formulas have a special
class. Use \code{is_lambda()} to test for it.

Lambdas currently do not support \link{quasiquotation},
due to the way the arguments are handled internally.}

\item{env}{Environment in which to fetch the function in case \code{x}
is a string.}
}
\description{
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("stable")}
\itemize{
\item \code{as_function()} transforms a one-sided formula into a function.
This powers the lambda syntax in packages like purrr.
\item \code{as_closure()} first passes its argument to \code{as_function()}. If
the result is a primitive function, it regularises it to a proper
\link{closure} (see \code{\link[=is_function]{is_function()}} about primitive functions). Some
special control flow primitives like \code{if}, \code{for}, or \code{break}
can't be coerced to a closure.
}
}
\examples{
f <- as_function(~ .x + 1)
f(10)

g <- as_function(~ -1 * .)
g(4)

h <- as_function(~ .x - .y)
h(6, 3)

# Functions created from a formula have a special class:
is_lambda(f)
is_lambda(as_function(function() "foo"))

# Primitive functions are regularised as closures
as_closure(list)
as_closure("list")

# Operators have `.x` and `.y` as arguments, just like lambda
# functions created with the formula syntax:
as_closure(`+`)
as_closure(`~`)

# Use a regular function for tidy evaluation, also when calling functions
# that use tidy evaluation:
## Bad:
e <- as_function(~ as_label(ensym(.x)))
## Good:
e <- as_function(function(x) as_label(ensym(x)))

e(y)
}
