% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{is_integerish}
\alias{is_integerish}
\alias{is_bare_integerish}
\alias{is_scalar_integerish}
\title{Is a vector integer-like?}
\usage{
is_integerish(x, n = NULL, finite = TRUE)

is_bare_integerish(x, n = NULL)

is_scalar_integerish(x)
}
\arguments{
\item{x}{Object to be tested.}

\item{n}{Expected length of a vector.}

\item{finite}{Whether values must be finite. Examples of non-finite
values are \code{Inf}, \code{-Inf} and \code{NaN}.}
}
\description{
These predicates check whether R considers a number vector to be
integer-like, according to its own tolerance check (which is in
fact delegated to the C library). This function is not adapted to
data analysis, see the help for \code{\link[base:is.integer]{base::is.integer()}} for examples
of how to check for whole numbers.
}
\examples{
is_integerish(10L)
is_integerish(10.0)
is_integerish(10.0, n = 2)
is_integerish(10.000001)
is_integerish(TRUE)
}
\seealso{
\code{\link[=is_bare_numeric]{is_bare_numeric()}} for testing whether an object is a
base numeric type (a bare double or integer vector).
}
