% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dots.R, R/quos.R
\name{dots_definitions}
\alias{dots_definitions}
\alias{quosures}
\alias{quos}
\alias{is_quosures}
\title{Tidy quotation of multiple expressions and dots}
\usage{
dots_definitions(..., .named = FALSE)

quos(..., .named = FALSE, .ignore_empty = c("trailing", "none", "all"))

is_quosures(x)
}
\arguments{
\item{...}{Expressions to capture unevaluated.}

\item{.named}{Whether to ensure all dots are named. Unnamed
elements are processed with \code{\link[=expr_text]{expr_text()}} to figure out a default
name. If an integer, it is passed to the \code{width} argument of
\code{expr_text()}, if \code{TRUE}, the default width is used. See
\code{\link[=exprs_auto_name]{exprs_auto_name()}}.}

\item{.ignore_empty}{Whether to ignore empty arguments. Can be one
of \code{"trailing"}, \code{"none"}, \code{"all"}. If \code{"trailing"}, only the
last argument is ignored if it is empty.}

\item{x}{An object to test.}
}
\description{
\code{quos()} quotes its arguments and returns them as a list of
quosures (see \code{\link[=quo]{quo()}}). It is especially useful to capture
arguments forwarded through \code{...}.
}
\details{
Both \code{quos} and \code{dots_definitions()} have specific support for
definition expressions of the type \code{var := expr}, with some
differences:

\describe{
\item{\code{quos()}}{
When \code{:=} definitions are supplied to \code{quos()}, they are treated
as a synonym of argument assignment \code{=}. On the other hand, they
allow unquoting operators on the left-hand side, which makes it
easy to assign names programmatically.}
\item{\code{dots_definitions()}}{
This dots capturing function returns definitions as is. Unquote
operators are processed on capture, in both the LHS and the
RHS. Unlike \code{quos()}, it allows named definitions.}
}
}
\examples{
# quos() is like the singular version but allows quoting
# several arguments:
quos(foo(), bar(baz), letters[1:2], !! letters[1:2])

# It is most useful when used with dots. This allows quoting
# expressions across different levels of function calls:
fn <- function(...) quos(...)
fn(foo(bar), baz)

# Note that quos() does not check for duplicate named
# arguments:
fn <- function(...) quos(x = x, ...)
fn(x = a + b)


# Dots can be spliced in:
args <- list(x = 1:3, y = ~var)
quos(!!! args, z = 10L)

# Raw expressions are turned to formulas:
args <- alist(x = foo, y = bar)
quos(!!! args)


# Definitions are treated similarly to named arguments:
quos(x := expr, y = expr)

# However, the LHS of definitions can be unquoted. The return value
# must be a symbol or a string:
var <- "foo"
quos(!!var := expr)

# If you need the full LHS expression, use dots_definitions():
dots <- dots_definitions(var = foo(baz) := bar(baz))
dots$defs
}
