% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetMatrix.R
\name{fastHadamard}
\alias{fastHadamard}
\title{Compute fast Hadamard-transform of vector}
\usage{
fastHadamard(x, pad = FALSE)
}
\arguments{
\item{x}{vector of values to be transformed}

\item{pad}{optional logical asking whether vector not of length \eqn{2^k} should be
padded with zeroes}
}
\value{
A vector of the same length as x
}
\description{
Passes vector through Hadamard orthogonal design matrix.  Also known
as the Fast Walsh-Hadamard transform.
}
\details{
This is equivalent to multiplying by \code{designMatrix(log2(length(x)))} 
but should run much faster
}
\examples{

fastHadamard(1:8)
fastHadamard(1:5, pad=TRUE)

}
\seealso{
\code{\link{designMatrix}}, \code{\link{subsetMatrix}}.
}
\author{
Robin Evans
}
\keyword{arith}
