% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rix.R
\name{rix}
\alias{rix}
\title{Generate a Nix expression that builds a reproducible development environment}
\usage{
rix(
  r_ver = NULL,
  date = NULL,
  r_pkgs = NULL,
  system_pkgs = NULL,
  git_pkgs = NULL,
  local_r_pkgs = NULL,
  tex_pkgs = NULL,
  ide = "none",
  project_path,
  overwrite = FALSE,
  print = FALSE,
  message_type = "simple",
  shell_hook = NULL,
  skip_post_processing = FALSE
)
}
\arguments{
\item{r_ver}{Character. The required R version, for example "4.0.0". You can
check which R versions are available using \code{available_r()}, and for more
details check \code{available_df()}. For reproducibility purposes, you can also
provide a \code{nixpkgs} revision directly. For older versions of R, \code{nix-build}
might fail with an error stating 'this derivation is not meant to be
built'. In this case, simply drop into the shell with \code{nix-shell} instead
of building it first. It is also possible to provide either "bleeding-edge"
or "frozen-edge" if you need an environment with bleeding edge packages.
Read more in the "Details" section below.}

\item{date}{Character. Instead of providing \code{r_ver}, it is also possible to
provide a date. This will build an environment containing R and R packages
(and other dependencies) as of that date. You can check which dates are
available with \code{available_dates()}. For more details about versions check
\code{available_df()}.}

\item{r_pkgs}{Vector of characters. List the required R packages for your
analysis here.}

\item{system_pkgs}{Vector of characters. List further software you wish to
install that are not R packages such as command line applications for
example. You can look for available software on the NixOS website
\url{https://search.nixos.org/packages?channel=unstable&from=0&size=50&sort=relevance&type=packages&query=}}

\item{git_pkgs}{List. A list of packages to install from Git. See details for
more information.}

\item{local_r_pkgs}{List. A list of local packages to install. These packages
need to be in the \code{.tar.gz} or \code{.zip} formats and must be in the same
folder as the generated "default.nix" file.}

\item{tex_pkgs}{Vector of characters. A set of TeX packages to install. Use
this if you need to compile \code{.tex} documents, or build PDF documents using
Quarto. If you don't know which package to add, start by adding "amsmath".
See the
\code{vignette("d2- installing-system-tools-and-texlive-packages-in-a-nix-environment")}
for more details.}

\item{ide}{Character, defaults to "none". If you wish to use RStudio to work
interactively use "rstudio" or "rserver" for the server version. Use "code"
for Visual Studio Code or "codium" for Codium, or "positron" for Positron.
You can also use "radian", an interactive REPL. This will install a
project-specific version of the chosen editor which will be differrent than
the one already present in your system (if any). For other editors or if
you want to use an editor already installed on your system (which will
require some configuration to make it work seamlessly with Nix shells see
the \code{vignette("e-configuring-ide")} for configuration examples), use
"none". Please be aware that VS Code and Positron are not free software. To
facilitate their installation, \code{rix()} automatically enables a required
setting without prompting the user for confirmation. See the "Details"
section below for more information.}

\item{project_path}{Character, where to write \code{default.nix}, for example
"/home/path/to/project". The file will thus be written to the file
"/home/path/to/project/default.nix". If the folder does not exist, it will
be created.}

\item{overwrite}{Logical, defaults to FALSE. If TRUE, overwrite the
\code{default.nix} file in the specified path.}

\item{print}{Logical, defaults to FALSE. If TRUE, print \code{default.nix} to
console.}

\item{message_type}{Character. Message type, defaults to \code{"simple"}, which
gives minimal but sufficient feedback. Other values are currently
\verb{"quiet}, which generates the files without message, and \code{"verbose"},
displays all the messages.}

\item{shell_hook}{Character of length 1, defaults to \code{NULL}. Commands added
to the \code{shellHook} variable are executed when the Nix shell starts. So by
default, using \verb{nix-shell default.nix} will start a specific program,
possibly with flags (separated by space), and/or do shell actions. You can
for example use \code{shell_hook = R}, if you want to directly enter the
declared Nix R session when dropping into the Nix shell.}

\item{skip_post_processing}{Logical, defaults to FALSE. Should post-processing be
skipped? By default, if there are GitHub packages, the generated \code{default.nix}
is post-processed to eliminate potential duplicate definitions of packages,
which may happen if these packages have recursive remote dependencies. Set
to TRUE to skip post processing, which might be useful for debugging.}
}
\value{
Nothing, this function only has the side-effect of writing two files:
\code{default.nix} and \code{.Rprofile} in the working directory. \code{default.nix}
contains a Nix expression to build a reproducible environment using the Nix
package manager, and \code{.Rprofile} ensures that a running R session from a
Nix environment cannot access local libraries, nor install packages using
\code{install.packages()} (nor remove nor update them).
}
\description{
Generate a Nix expression that builds a reproducible development environment
}
\details{
This function will write a \code{default.nix} and an \code{.Rprofile} in the
chosen path. Using the Nix package manager, it is then possible to build a
reproducible development environment using the \code{nix-build} command in the
path. This environment will contain the chosen version of R and packages,
and will not interfere with any other installed version (via Nix or not) on
your machine. Every dependency, including both R package dependencies but
also system dependencies like compilers will get installed as well in that
environment.

It is possible to use environments built with Nix interactively, either
from the terminal, or using an interface such as RStudio. If you want to
use RStudio, set the \code{ide} argument to \code{"rstudio"}. Please be aware that
RStudio is not available for macOS through Nix. As such, you may want to
use another editor on macOS. To use Visual Studio Code (or Codium), set the
\code{ide} argument to \code{"code"} or \code{"codium"} respectively, which will add the
\code{{languageserver}} R package to the list of R packages to be installed by
Nix in that environment. It is also possible to use Positron by setting the
\code{ide} argument to \code{"positron"}. Setting the \code{ide} argument to an editor
will install it from Nix, meaning that each of your projects can have a
dedicated IDE (or IDE version). \code{"radian"} and \code{"rserver"} are also
options.

Instead of using Nix to install an IDE, you can also simply use the one you
have already installed on your system, with the exception of RStudio which
must be managed by Nix to "see" Nix environments. Positron must also be
heavily configured to work with Nix shells, so we recommend installing it
using Nix. To use an editor that you already have installed on your system,
set \code{ide = "none"} and refer to the \code{vignette("e-configuring-ide")} for
more details on how to set up your editor to work with Nix shells.

Packages to install from GitHub or Gitlab must be provided in a list of 3
elements: "package_name", "repo_url" and "commit". To install several
packages, provide a list of lists of these 3 elements, one per package to
install. It is also possible to install old versions of packages by
specifying a version. For example, to install the latest version of \code{{AER}}
but an old version of \code{{ggplot2}}, you could write: \code{r_pkgs = c("AER", "ggplot2@2.2.1")}. Note however that doing this could result in dependency
hell, because an older version of a package might need older versions of
its dependencies, but other packages might need more recent versions of the
same dependencies. If instead you want to use an environment as it would
have looked at the time of \code{{ggplot2}}'s version 2.2.1 release, then use
the Nix revision closest to that date, by setting \code{r_ver = "3.1.0"}, which
was the version of R current at the time. This ensures that Nix builds a
completely coherent environment. For security purposes, users that wish to
install packages from GitHub/Gitlab or from the CRAN archives must provide
a security hash for each package. \code{{rix}} automatically precomputes this
hash for the source directory of R packages from GitHub/Gitlab or from the
CRAN archives, to make sure the expected trusted sources that match the
precomputed hashes in the \code{default.nix} are downloaded. If Nix is
available, then the hash will be computed on the user's machine, however,
if Nix is not available, then the hash gets computed on a server that we
set up for this purposes. This server then returns the security hash as
well as the dependencies of the packages. It is possible to control this
behaviour using \code{options(rix.sri_hash=x)}, where \code{x} is one of "check_nix"
(the default), "locally" (use the local Nix installation) or "api_server"
(use the remote server to compute and return the hash).

Note that installing packages from Git or old versions using the \code{"@"}
notation or local packages, does not leverage Nix's capabilities for
dependency solving. As such, you might have trouble installing these
packages. If that is the case, open an issue on \code{{rix}}'s GitHub
repository.

If GitHub packages have dependencies on GitHub as well, \code{{rix}} will
attempt to generate the correct expression, but we highly recommend you
read the
\code{vignette("z-advanced-topic-handling-packages-with-remote-dependencies")}
Vignette.

By default, the Nix shell will be configured with \code{"en_US.UTF-8"} for the
relevant locale variables (\code{LANG}, \code{LC_ALL}, \code{LC_TIME}, \code{LC_MONETARY},
\code{LC_PAPER}, \code{LC_MEASUREMENT}). This is done to ensure locale
reproducibility by default in Nix environments created with \code{rix()}. If
there are good reasons to not stick to the default, you can set your
preferred locale variables via \verb{options(rix.nix_locale_variables = list(LANG = "de_CH.UTF-8", <...>)} and the aforementioned locale variable
names.

It is possible to use \verb{"bleeding-edge}" or \verb{"frozen-edge}" as the value for
the \code{r_ver} argument. This will create an environment with the very latest
R packages. \verb{"bleeding-edge}" means that every time you will build the
environment, the packages will get updated. This is especially useful for
environments that need to be constantly updated, for example when
developing a package. In contrast, \verb{"frozen-edge}" will create an
environment that will remain stable at build time. So if you create a
\code{default.nix} file using \verb{"bleeding-edge}", each time you build it using
\code{nix-build} that environment will be up-to-date. With \verb{"frozen-edge}" that
environment will be up-to-date on the date that the \code{default.nix} will be
generated, and then each subsequent call to \code{nix-build} will result in the
same environment. \code{"bioc-devel"} is the same as \code{"bleeding-edge"}, but also
adds the development version of Bioconductor. \code{"r-devel"} is the same as
bleeding edge, but with the R development version instead of the latest
stable version and \code{"r-devel-bioc-devel"} is the same as \code{"r-devel"} but
with Bioconductor on the development version. We highly recommend you read
the vignette titled
"z - Advanced topic: Understanding the rPackages set release cycle and
using bleeding edge packages".
}
\examples{
\dontrun{
# Build an environment with the latest version of R available from Nixpkgs
# and the dplyr and ggplot2 packages
rix(
  r_ver = "latest-upstream",
  r_pkgs = c("dplyr", "ggplot2"),
  system_pkgs = NULL,
  git_pkgs = NULL,
  local_r_pkgs = NULL,
  ide = "code",
  project_path = path_default_nix,
  overwrite = TRUE,
  print = TRUE,
  message_type = "simple",
  shell_hook = NULL,
  skip_post_processing = FALSE
)
}
}
