% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ga_cachix.R
\name{ga_cachix}
\alias{ga_cachix}
\title{ga_cachix Build an environment on GitHub Actions and cache it on Cachix}
\usage{
ga_cachix(cache_name, path_default)
}
\arguments{
\item{cache_name}{String, name of your cache.}

\item{path_default}{String, relative path (from the root directory of your project)
to the \code{default.nix} to build.}
}
\value{
Nothing, copies file to a directory.
}
\description{
ga_cachix Build an environment on GitHub Actions and cache it on Cachix
}
\details{
This function puts a \code{.yaml} file inside the \verb{.github/workflows/}
folders on the root of your project. This workflow file will use the
projects \code{default.nix} file to generate the development environment on
GitHub Actions and will then cache the created binaries in Cachix. Create a
free account on Cachix to use this action. Refer to
\code{vignette("z-binary_cache")} for detailed instructions. Make sure to give
read and write permissions to the GitHub Actions bot.
}
\examples{
\dontrun{
ga_cachix("my-cachix", path_default = "default.nix")
}
}
