% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{normal_depth}
\alias{normal_depth}
\title{Normal depth}
\usage{
normal_depth(So, n, Q, yopt, Cm, B, SS)
}
\arguments{
\item{So}{Channel slope [\eqn{L L^{-1}}].}

\item{n}{Manning's roughness coefficient.}

\item{Q}{Flow rate [\eqn{L^3 T^{-1}}].}

\item{yopt}{Initial guess for normal depth [\eqn{L}].}

\item{Cm}{Unit conversion coefficient for Manning's equation. For SI units, Cm = 1.}

\item{B}{Channel bottom width [\eqn{L}].}

\item{SS}{Channel sideslope [\eqn{L L^{-1}}].}
}
\value{
The normal depth \eqn{y_n} [\eqn{L}].
}
\description{
Calculate the normal (equilibrium) depth using Manning's equation.
}
\details{
The normal depth is the equilibrium depth of a channel for a given
  flow rate, channel slope, geometry and roughness.
  Manning's equation is used to calculate the equilibrium depth. Manning's
  equation for normal flow is defined as \deqn{Q = \frac{C_m}{n} AR^{2/3}S_0^{1/2}}
  where \eqn{Q} is the channel flow, \eqn{S_0} is the channel slope, \eqn{A} is the
  cross-sectional flow area, \eqn{R} is the hydraulic depth and \eqn{C_m} is a conversion factor
  based on the unit system used. This function uses a Newton-Raphson root-finding approach
  to calculate the normal depth, i.e.
  \eqn{y = y_n} when \deqn{f(y) = \frac{A^{5/3}}{P^{2/3}} - \frac{nQ}{C_mS_0^{1/2}} = 0}.
}
\examples{
normal_depth(0.001, 0.045, 250, 3, 1.486, 100, 0) # rectangular channel
normal_depth(0.0008, 0.013, 126, 5, 1, 6.1, 1.5) # trapezoidal channel with sideslope 3H:2V
}

